/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.culture;

import com.tyme.LoopTyme;
import com.tyme.jd.JulianDay;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarMonth;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTime;
import com.tyme.util.ShouXingUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0004J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tyme/culture/Phase;", "Lcom/tyme/LoopTyme;", "lunarYear", "", "lunarMonth", "index", "<init>", "(III)V", "name", "", "(IILjava/lang/String;)V", "next", "n", "getStartSolarTime", "Lcom/tyme/solar/SolarTime;", "getSolarTime", "getSolarDay", "Lcom/tyme/solar/SolarDay;", "Companion", "tyme4kt"})
public final class Phase
extends LoopTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int lunarYear;
    private int lunarMonth;
    @NotNull
    private static final String[] NAMES;

    public Phase(int lunarYear, int lunarMonth, int index) {
        super(NAMES, index);
        LunarMonth m = LunarMonth.Companion.fromYm(lunarYear, lunarMonth).next(index / this.getSize());
        this.lunarYear = m.getYear();
        this.lunarMonth = m.getMonthWithLeap();
    }

    public Phase(int lunarYear, int lunarMonth, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(NAMES, name);
        this.lunarYear = lunarYear;
        this.lunarMonth = lunarMonth;
    }

    @Override
    @NotNull
    public Phase next(int n) {
        int size = this.getSize();
        int i = this.getIndex() + n;
        if (i < 0) {
            i -= size;
        }
        LunarMonth m = LunarMonth.Companion.fromYm(this.lunarYear, this.lunarMonth);
        if ((i /= size) != 0) {
            m = m.next(i);
        }
        return Companion.fromIndex(m.getYear(), m.getMonthWithLeap(), this.nextIndex(n));
    }

    @NotNull
    protected final SolarTime getStartSolarTime() {
        double t;
        int n = (int)Math.floor((double)(this.lunarYear - 2000) * 365.2422 / 29.53058886);
        int i = 0;
        SolarDay d = LunarDay.Companion.fromYmd(this.lunarYear, this.lunarMonth, 1).getSolarDay();
        double jd = 2451545.3333333335;
        while (JulianDay.Companion.fromJulianDay(jd + (t = ShouXingUtil.INSTANCE.msaLonT((double)(n + i) * (Math.PI * 2)) * (double)36525) - ShouXingUtil.INSTANCE.dtT(t)).getSolarDay().isBefore(d)) {
            ++i;
        }
        int[] nArray = new int[]{0, 90, 180, 270};
        int[] r = nArray;
        double t2 = ShouXingUtil.INSTANCE.msaLonT(((double)(n + i) + (double)r[this.getIndex() / 2] / 360.0) * (Math.PI * 2)) * (double)36525;
        return JulianDay.Companion.fromJulianDay(jd + t2 - ShouXingUtil.INSTANCE.dtT(t2)).getSolarTime();
    }

    @NotNull
    public final SolarTime getSolarTime() {
        SolarTime t = this.getStartSolarTime();
        return this.getIndex() % 2 == 1 ? t.next(1) : t;
    }

    @NotNull
    public final SolarDay getSolarDay() {
        SolarDay d = this.getStartSolarTime().getSolarDay();
        return this.getIndex() % 2 == 1 ? d.next(1) : d;
    }

    @JvmStatic
    @NotNull
    public static final Phase fromIndex(int lunarYear, int lunarMonth, int index) {
        return Companion.fromIndex(lunarYear, lunarMonth, index);
    }

    @JvmStatic
    @NotNull
    public static final Phase fromName(int lunarYear, int lunarMonth, @NotNull String name) {
        return Companion.fromName(lunarYear, lunarMonth, name);
    }

    static {
        String[] stringArray = new String[]{"\u65b0\u6708", "\u86fe\u7709\u6708", "\u4e0a\u5f26\u6708", "\u76c8\u51f8\u6708", "\u6ee1\u6708", "\u4e8f\u51f8\u6708", "\u4e0b\u5f26\u6708", "\u6b8b\u6708"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/tyme/culture/Phase$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromIndex", "Lcom/tyme/culture/Phase;", "lunarYear", "", "lunarMonth", "index", "fromName", "name", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final Phase fromIndex(int lunarYear, int lunarMonth, int index) {
            return new Phase(lunarYear, lunarMonth, index);
        }

        @JvmStatic
        @NotNull
        public final Phase fromName(int lunarYear, int lunarMonth, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Phase(lunarYear, lunarMonth, name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

