/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Duty;
import com.tyme.culture.Element;
import com.tyme.culture.God;
import com.tyme.culture.Phase;
import com.tyme.culture.PhaseDay;
import com.tyme.culture.Taboo;
import com.tyme.culture.Week;
import com.tyme.culture.fetus.FetusDay;
import com.tyme.culture.ren.MinorRen;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.six.SixStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.culture.star.twentyeight.TwentyEightStar;
import com.tyme.festival.LunarFestival;
import com.tyme.lunar.LunarHour;
import com.tyme.lunar.LunarMonth;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\nJ\u0006\u0010/\u001a\u00020\fJ\u0006\u00100\u001a\u000201J\b\u00102\u001a\u0004\u0018\u000103J\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\f\u00107\u001a\b\u0012\u0004\u0012\u00020805J\f\u00109\u001a\b\u0012\u0004\u0012\u00020:05J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020:05J\u0006\u0010<\u001a\u00020=J\u0013\u0010>\u001a\u00020\u00172\b\u0010?\u001a\u0004\u0018\u00010@H\u0096\u0002J\b\u0010A\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/tyme/lunar/LunarDay;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "day", "<init>", "(III)V", "Lcom/tyme/lunar/LunarMonth;", "solarDay", "Lcom/tyme/solar/SolarDay;", "sixtyCycleDay", "Lcom/tyme/sixtycycle/SixtyCycleDay;", "getLunarMonth", "getYear", "getMonth", "getDay", "getName", "", "toString", "next", "n", "isBefore", "", "target", "isAfter", "getWeek", "Lcom/tyme/culture/Week;", "getSixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "getDuty", "Lcom/tyme/culture/Duty;", "getTwelveStar", "Lcom/tyme/culture/star/twelve/TwelveStar;", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getJupiterDirection", "Lcom/tyme/culture/Direction;", "getFetusDay", "Lcom/tyme/culture/fetus/FetusDay;", "getPhaseDay", "Lcom/tyme/culture/PhaseDay;", "getPhase", "Lcom/tyme/culture/Phase;", "getSixStar", "Lcom/tyme/culture/star/six/SixStar;", "getSolarDay", "getSixtyCycleDay", "getTwentyEightStar", "Lcom/tyme/culture/star/twentyeight/TwentyEightStar;", "getFestival", "Lcom/tyme/festival/LunarFestival;", "getHours", "", "Lcom/tyme/lunar/LunarHour;", "getGods", "Lcom/tyme/culture/God;", "getRecommends", "Lcom/tyme/culture/Taboo;", "getAvoids", "getMinorRen", "Lcom/tyme/culture/ren/MinorRen;", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nLunarDay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LunarDay.kt\ncom/tyme/lunar/LunarDay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1#2:373\n*E\n"})
public final class LunarDay
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int day;
    @NotNull
    private LunarMonth month;
    @Nullable
    private SolarDay solarDay;
    @Nullable
    private SixtyCycleDay sixtyCycleDay;
    @NotNull
    private static final String[] NAMES;

    public LunarDay(int year, int month, int day) {
        this.day = day;
        LunarMonth m = LunarMonth.Companion.fromYm(year, month);
        int n = m.getDayCount();
        int n2 = this.day;
        if (!(1 <= n2 ? n2 <= n : false)) {
            boolean bl = false;
            String string = "illegal day " + this.day + " in " + m;
            throw new IllegalArgumentException(string.toString());
        }
        this.month = m;
    }

    @NotNull
    public final LunarMonth getLunarMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.month.getYear();
    }

    public final int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public final int getDay() {
        return this.day;
    }

    @Override
    @NotNull
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    @NotNull
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    @NotNull
    public LunarDay next(int n) {
        return this.getSolarDay().next(n).getLunarDay();
    }

    public final boolean isBefore(@NotNull LunarDay target) {
        int bMonth;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int aYear = this.getYear();
        int bYear = target.getYear();
        if (aYear != bYear) {
            return aYear < bYear;
        }
        int aMonth = this.getMonth();
        if (aMonth != (bMonth = target.getMonth())) {
            return Math.abs(aMonth) < Math.abs(bMonth);
        }
        return this.day < target.getDay();
    }

    public final boolean isAfter(@NotNull LunarDay target) {
        int bMonth;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int aYear = this.getYear();
        int bYear = target.getYear();
        if (aYear != bYear) {
            return aYear > bYear;
        }
        int aMonth = this.getMonth();
        if (aMonth != (bMonth = target.getMonth())) {
            return Math.abs(aMonth) >= Math.abs(bMonth);
        }
        return this.day > target.getDay();
    }

    @NotNull
    public final Week getWeek() {
        return this.getSolarDay().getWeek();
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        int offset = (int)this.month.getFirstJulianDay().next(this.day - 12).getDay();
        return new SixtyCycle(new HeavenStem(offset).getName() + new EarthBranch(offset).getName());
    }

    @NotNull
    public final Duty getDuty() {
        return this.getSixtyCycleDay().getDuty();
    }

    @NotNull
    public final TwelveStar getTwelveStar() {
        return this.getSixtyCycleDay().getTwelveStar();
    }

    @NotNull
    public final NineStar getNineStar() {
        SolarDay d = this.getSolarDay();
        SolarTerm dongZhi = new SolarTerm(d.getYear(), 0);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = dongZhi.next(12).getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi.next(24).getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!d.isBefore(solarShunBai) && d.isBefore(solarNiZi)) {
            offset = d.subtract(solarShunBai);
        } else if (!d.isBefore(solarNiZi) && d.isBefore(solarShunBai2)) {
            offset = 8 - d.subtract(solarNiZi);
        } else if (!d.isBefore(solarShunBai2)) {
            offset = d.subtract(solarShunBai2);
        } else if (d.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(d);
        }
        return new NineStar(offset);
    }

    @NotNull
    public final Direction getJupiterDirection() {
        int index = this.getSixtyCycle().getIndex();
        return index % 12 < 6 ? new Element(index / 12).getDirection() : this.month.getLunarYear().getJupiterDirection();
    }

    @NotNull
    public final FetusDay getFetusDay() {
        return FetusDay.Companion.fromLunarDay(this);
    }

    @NotNull
    public final PhaseDay getPhaseDay() {
        SolarDay today = this.getSolarDay();
        LunarMonth m = this.month.next(1);
        Phase p = Phase.Companion.fromIndex(m.getYear(), m.getMonthWithLeap(), 0);
        SolarDay d = p.getSolarDay();
        while (d.isAfter(today)) {
            p = p.next(-1);
            d = p.getSolarDay();
        }
        return new PhaseDay(p, today.subtract(d));
    }

    @NotNull
    public final Phase getPhase() {
        return this.getPhaseDay().getPhase();
    }

    @NotNull
    public final SixStar getSixStar() {
        return new SixStar((this.month.getMonth() + this.day - 2) % 6);
    }

    @NotNull
    public final SolarDay getSolarDay() {
        if (this.solarDay == null) {
            this.solarDay = this.month.getFirstJulianDay().next(this.day - 1).getSolarDay();
        }
        SolarDay solarDay = this.solarDay;
        Intrinsics.checkNotNull((Object)solarDay);
        return solarDay;
    }

    @NotNull
    public final SixtyCycleDay getSixtyCycleDay() {
        if (this.sixtyCycleDay == null) {
            this.sixtyCycleDay = this.getSolarDay().getSixtyCycleDay();
        }
        SixtyCycleDay sixtyCycleDay = this.sixtyCycleDay;
        Intrinsics.checkNotNull((Object)sixtyCycleDay);
        return sixtyCycleDay;
    }

    @NotNull
    public final TwentyEightStar getTwentyEightStar() {
        int[] nArray = new int[]{10, 18, 26, 6, 14, 22, 2};
        return new TwentyEightStar(nArray[this.getSolarDay().getWeek().getIndex()]).next(-7 * this.getSixtyCycle().getEarthBranch().getIndex());
    }

    @Nullable
    public final LunarFestival getFestival() {
        return LunarFestival.Companion.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    @NotNull
    public final List<LunarHour> getHours() {
        List l = new ArrayList();
        int y = this.getYear();
        int m = this.getMonth();
        l.add(new LunarHour(y, m, this.day, 0, 0, 0));
        for (int i = 0; i < 24; i += 2) {
            l.add(new LunarHour(y, m, this.day, i + 1, 0, 0));
        }
        return l;
    }

    @NotNull
    public final List<God> getGods() {
        return this.getSixtyCycleDay().getGods();
    }

    @NotNull
    public final List<Taboo> getRecommends() {
        return this.getSixtyCycleDay().getRecommends();
    }

    @NotNull
    public final List<Taboo> getAvoids() {
        return this.getSixtyCycleDay().getAvoids();
    }

    @NotNull
    public final MinorRen getMinorRen() {
        return this.getLunarMonth().getMinorRen().next(this.day - 1);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LunarDay && Intrinsics.areEqual((Object)this.toString(), (Object)((LunarDay)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final LunarDay fromYmd(int year, int month, int day) {
        return Companion.fromYmd(year, month, day);
    }

    static {
        String[] stringArray = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/tyme/lunar/LunarDay$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromYmd", "Lcom/tyme/lunar/LunarDay;", "year", "", "month", "day", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final LunarDay fromYmd(int year, int month, int day) {
            return new LunarDay(year, month, day);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

