/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Duty;
import com.tyme.culture.Element;
import com.tyme.culture.God;
import com.tyme.culture.Taboo;
import com.tyme.culture.fetus.FetusDay;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.culture.star.twentyeight.TwentyEightStar;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarMonth;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleHour;
import com.tyme.sixtycycle.SixtyCycleMonth;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0 J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0016J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/tyme/sixtycycle/SixtyCycleDay;", "Lcom/tyme/AbstractTyme;", "solarDay", "Lcom/tyme/solar/SolarDay;", "month", "Lcom/tyme/sixtycycle/SixtyCycleMonth;", "day", "Lcom/tyme/sixtycycle/SixtyCycle;", "<init>", "(Lcom/tyme/solar/SolarDay;Lcom/tyme/sixtycycle/SixtyCycleMonth;Lcom/tyme/sixtycycle/SixtyCycle;)V", "(Lcom/tyme/solar/SolarDay;)V", "getSolarDay", "getSixtyCycleMonth", "getYear", "getMonth", "getSixtyCycle", "getName", "", "toString", "getDuty", "Lcom/tyme/culture/Duty;", "getTwelveStar", "Lcom/tyme/culture/star/twelve/TwelveStar;", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getJupiterDirection", "Lcom/tyme/culture/Direction;", "getFetusDay", "Lcom/tyme/culture/fetus/FetusDay;", "getTwentyEightStar", "Lcom/tyme/culture/star/twentyeight/TwentyEightStar;", "getGods", "", "Lcom/tyme/culture/God;", "getRecommends", "Lcom/tyme/culture/Taboo;", "getAvoids", "next", "n", "", "getHours", "Lcom/tyme/sixtycycle/SixtyCycleHour;", "Companion", "tyme4kt"})
public final class SixtyCycleDay
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SolarDay solarDay;
    @NotNull
    private SixtyCycleMonth month;
    @NotNull
    private SixtyCycle day;

    public SixtyCycleDay(@NotNull SolarDay solarDay, @NotNull SixtyCycleMonth month, @NotNull SixtyCycle day) {
        Intrinsics.checkNotNullParameter((Object)solarDay, (String)"solarDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        this.solarDay = solarDay;
        this.month = month;
        this.day = day;
    }

    public SixtyCycleDay(@NotNull SolarDay solarDay) {
        SolarTerm term;
        int index;
        Intrinsics.checkNotNullParameter((Object)solarDay, (String)"solarDay");
        int solarYear = solarDay.getYear();
        SolarDay springSolarDay = new SolarTerm(solarYear, 3).getJulianDay().getSolarDay();
        LunarDay lunarDay = solarDay.getLunarDay();
        LunarYear lunarYear = lunarDay.getLunarMonth().getLunarYear();
        if (lunarYear.getYear() == solarYear) {
            if (solarDay.isBefore(springSolarDay)) {
                lunarYear = lunarYear.next(-1);
            }
        } else if (lunarYear.getYear() < solarYear && !solarDay.isBefore(springSolarDay)) {
            lunarYear = lunarYear.next(1);
        }
        if ((index = (term = solarDay.getTerm()).getIndex() - 3) < 0 && term.getJulianDay().getSolarDay().isAfter(springSolarDay)) {
            index += 24;
        }
        this.solarDay = solarDay;
        this.month = new SixtyCycleMonth(new SixtyCycleYear(lunarYear.getYear()), LunarMonth.Companion.fromYm(solarYear, 1).getSixtyCycle().next((int)Math.floor((double)index * 0.5)));
        this.day = lunarDay.getSixtyCycle();
    }

    @NotNull
    public final SolarDay getSolarDay() {
        return this.solarDay;
    }

    @NotNull
    public final SixtyCycleMonth getSixtyCycleMonth() {
        return this.month;
    }

    @NotNull
    public final SixtyCycle getYear() {
        return this.month.getYear();
    }

    @NotNull
    public final SixtyCycle getMonth() {
        return this.month.getSixtyCycle();
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        return this.day;
    }

    @Override
    @NotNull
    public String getName() {
        return this.day.getName() + "\u65e5";
    }

    @Override
    @NotNull
    public String toString() {
        return this.month + this.getName();
    }

    @NotNull
    public final Duty getDuty() {
        return new Duty(this.day.getEarthBranch().getIndex() - this.getMonth().getEarthBranch().getIndex());
    }

    @NotNull
    public final TwelveStar getTwelveStar() {
        return new TwelveStar(this.day.getEarthBranch().getIndex() + (8 - this.getMonth().getEarthBranch().getIndex() % 6) * 2);
    }

    @NotNull
    public final NineStar getNineStar() {
        SolarDay solar = this.getSolarDay();
        SolarTerm dongZhi = new SolarTerm(solar.getYear(), 0);
        SolarTerm xiaZhi = dongZhi.next(12);
        SolarTerm dongZhi2 = dongZhi.next(24);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = xiaZhi.getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi2.getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!solar.isBefore(solarShunBai) && solar.isBefore(solarNiZi)) {
            offset = solar.subtract(solarShunBai);
        } else if (!solar.isBefore(solarNiZi) && solar.isBefore(solarShunBai2)) {
            offset = 8 - solar.subtract(solarNiZi);
        } else if (!solar.isBefore(solarShunBai2)) {
            offset = solar.subtract(solarShunBai2);
        } else if (solar.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(solar);
        }
        return new NineStar(offset);
    }

    @NotNull
    public final Direction getJupiterDirection() {
        int index = this.day.getIndex();
        return index % 12 < 6 ? new Element(index / 12).getDirection() : this.month.getSixtyCycleYear().getJupiterDirection();
    }

    @NotNull
    public final FetusDay getFetusDay() {
        return FetusDay.Companion.fromSixtyCycleDay(this);
    }

    @NotNull
    public final TwentyEightStar getTwentyEightStar() {
        int[] nArray = new int[]{10, 18, 26, 6, 14, 22, 2};
        return new TwentyEightStar(nArray[this.solarDay.getWeek().getIndex()]).next(-7 * this.day.getEarthBranch().getIndex());
    }

    @NotNull
    public final List<God> getGods() {
        return God.Companion.getDayGods(this.getMonth(), this.day);
    }

    @NotNull
    public final List<Taboo> getRecommends() {
        return Taboo.Companion.getDayRecommends(this.getMonth(), this.day);
    }

    @NotNull
    public final List<Taboo> getAvoids() {
        return Taboo.Companion.getDayAvoids(this.getMonth(), this.day);
    }

    @Override
    @NotNull
    public SixtyCycleDay next(int n) {
        return new SixtyCycleDay(this.solarDay.next(n));
    }

    @NotNull
    public final List<SixtyCycleHour> getHours() {
        List l = new ArrayList();
        SolarDay d = this.solarDay.next(-1);
        SixtyCycleHour h = new SixtyCycleHour(new SolarTime(d.getYear(), d.getMonth(), d.getDay(), 23, 0, 0));
        l.add(h);
        for (int i = 0; i < 11; ++i) {
            h = h.next(7200);
            l.add(h);
        }
        return l;
    }

    @JvmStatic
    @NotNull
    public static final SixtyCycleDay fromSolarDay(@NotNull SolarDay solarDay) {
        return Companion.fromSolarDay(solarDay);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/tyme/sixtycycle/SixtyCycleDay$Companion;", "", "<init>", "()V", "fromSolarDay", "Lcom/tyme/sixtycycle/SixtyCycleDay;", "solarDay", "Lcom/tyme/solar/SolarDay;", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SixtyCycleDay fromSolarDay(@NotNull SolarDay solarDay) {
            Intrinsics.checkNotNullParameter((Object)solarDay, (String)"solarDay");
            return new SixtyCycleDay(solarDay);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

