/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarTerm;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/tyme/sixtycycle/SixtyCycleMonth;", "Lcom/tyme/AbstractTyme;", "year", "Lcom/tyme/sixtycycle/SixtyCycleYear;", "month", "Lcom/tyme/sixtycycle/SixtyCycle;", "<init>", "(Lcom/tyme/sixtycycle/SixtyCycleYear;Lcom/tyme/sixtycycle/SixtyCycle;)V", "getYear", "()Lcom/tyme/sixtycycle/SixtyCycleYear;", "setYear", "(Lcom/tyme/sixtycycle/SixtyCycleYear;)V", "getMonth", "()Lcom/tyme/sixtycycle/SixtyCycle;", "setMonth", "(Lcom/tyme/sixtycycle/SixtyCycle;)V", "getSixtyCycleYear", "getSixtyCycle", "getName", "", "toString", "next", "n", "", "getIndexInYear", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getJupiterDirection", "Lcom/tyme/culture/Direction;", "getFirstDay", "Lcom/tyme/sixtycycle/SixtyCycleDay;", "getDays", "", "Companion", "tyme4kt"})
public final class SixtyCycleMonth
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SixtyCycleYear year;
    @NotNull
    private SixtyCycle month;

    public SixtyCycleMonth(@NotNull SixtyCycleYear year, @NotNull SixtyCycle month) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.year = year;
        this.month = month;
    }

    @NotNull
    protected final SixtyCycleYear getYear() {
        return this.year;
    }

    protected final void setYear(@NotNull SixtyCycleYear sixtyCycleYear) {
        Intrinsics.checkNotNullParameter((Object)sixtyCycleYear, (String)"<set-?>");
        this.year = sixtyCycleYear;
    }

    @NotNull
    protected final SixtyCycle getMonth() {
        return this.month;
    }

    protected final void setMonth(@NotNull SixtyCycle sixtyCycle) {
        Intrinsics.checkNotNullParameter((Object)sixtyCycle, (String)"<set-?>");
        this.month = sixtyCycle;
    }

    @NotNull
    public final SixtyCycleYear getSixtyCycleYear() {
        return this.year;
    }

    @NotNull
    public final SixtyCycle getYear() {
        return this.year.getSixtyCycle();
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        return this.month;
    }

    @Override
    @NotNull
    public String getName() {
        return this.month.getName() + "\u6708";
    }

    @Override
    @NotNull
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    @NotNull
    public SixtyCycleMonth next(int n) {
        return new SixtyCycleMonth(new SixtyCycleYear((this.year.getYear() * 12 + this.getIndexInYear() + n) / 12), this.month.next(n));
    }

    public final int getIndexInYear() {
        return this.month.getEarthBranch().next(-2).getIndex();
    }

    @NotNull
    public final NineStar getNineStar() {
        int index = this.getSixtyCycle().getEarthBranch().getIndex();
        if (index < 2) {
            index += 3;
        }
        return new NineStar(27 - this.year.getSixtyCycle().getEarthBranch().getIndex() % 3 * 3 - index);
    }

    @NotNull
    public final Direction getJupiterDirection() {
        SixtyCycle sixtyCycle = this.getSixtyCycle();
        int[] nArray = new int[]{7, -1, 1, 3};
        int n = nArray[sixtyCycle.getEarthBranch().next(-2).getIndex() % 4];
        return n == -1 ? sixtyCycle.getHeavenStem().getDirection() : new Direction(n);
    }

    @NotNull
    public final SixtyCycleDay getFirstDay() {
        return new SixtyCycleDay(new SolarTerm(this.year.getYear(), 3 + this.getIndexInYear() * 2).getJulianDay().getSolarDay());
    }

    @NotNull
    public final List<SixtyCycleDay> getDays() {
        List l = new ArrayList();
        SixtyCycleDay d = this.getFirstDay();
        while (Intrinsics.areEqual((Object)d.getSixtyCycleMonth(), (Object)this)) {
            l.add(d);
            d = d.next(1);
        }
        return l;
    }

    @JvmStatic
    @NotNull
    public static final SixtyCycleMonth fromIndex(int year, int index) {
        return Companion.fromIndex(year, index);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/tyme/sixtycycle/SixtyCycleMonth$Companion;", "", "<init>", "()V", "fromIndex", "Lcom/tyme/sixtycycle/SixtyCycleMonth;", "year", "", "index", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SixtyCycleMonth fromIndex(int year, int index) {
            return new SixtyCycleYear(year).getFirstMonth().next(index);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

