/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.util.Assert;
import cn.acyou.leo.framework.util.SpringHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AsyncManager {
    private final ThreadPoolTaskExecutor taskExecutor = (ThreadPoolTaskExecutor)SpringHelper.getBean("threadPoolTaskExecutor");
    private final ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)SpringHelper.getBean("scheduledExecutorService");
    private static final AsyncManager ME = new AsyncManager();

    private AsyncManager() {
    }

    public static AsyncManager me() {
        return ME;
    }

    public void execute(Runnable task) {
        Assert.notNull((Object)this.taskExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[threadPoolTaskExecutor]");
        this.taskExecutor.execute(task);
    }

    public Future<?> submit(Runnable task) {
        Assert.notNull((Object)this.taskExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[threadPoolTaskExecutor]");
        return this.taskExecutor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Assert.notNull((Object)this.taskExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[threadPoolTaskExecutor]");
        return this.taskExecutor.submit(task);
    }

    public void schedule(Runnable task) {
        Assert.notNull((Object)this.scheduledExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[scheduledExecutorService]");
        this.scheduledExecutor.schedule(task, 10L, TimeUnit.MILLISECONDS);
    }

    public void schedule(Runnable task, long delay, TimeUnit unit) {
        Assert.notNull((Object)this.scheduledExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[scheduledExecutorService]");
        this.scheduledExecutor.schedule(task, delay, unit);
    }

    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Assert.notNull((Object)this.scheduledExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[scheduledExecutorService]");
        this.scheduledExecutor.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        Assert.notNull((Object)this.scheduledExecutor, "\u8bf7\u5148\u914d\u7f6e\u7ebf\u7a0b\u6c60\uff1a[scheduledExecutorService]");
        this.scheduledExecutor.scheduleWithFixedDelay(task, initialDelay, delay, unit);
    }

    public void shutdown() {
        this.taskExecutor.shutdown();
        this.scheduledExecutor.shutdown();
    }
}

