/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.mapper.tkMapper.util;

import cn.acyou.leo.framework.annotation.mapper.LogicDelete;
import cn.acyou.leo.framework.annotation.mapper.SelectiveIgnore;
import java.util.Set;
import tk.mybatis.mapper.LogicDeleteException;
import tk.mybatis.mapper.annotation.Version;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.version.VersionException;

public class TkSqlHelper
extends SqlHelper {
    public static String updateCustomSetColumns(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn versionColumn = null;
        for (EntityColumn column : columnSet) {
            boolean customIgnore = false;
            if (column.getEntityField().isAnnotationPresent(SelectiveIgnore.class)) {
                customIgnore = true;
            }
            if (column.getEntityField().isAnnotationPresent(Version.class)) {
                if (versionColumn != null) {
                    throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                versionColumn = column;
            }
            if (!column.isId() && column.isUpdatable()) {
                if (column == versionColumn) {
                    Version version = (Version)versionColumn.getEntityField().getAnnotation(Version.class);
                    String versionClass = version.nextVersion().getCanonicalName();
                    sql.append(column.getColumn()).append(" = ${@tk.mybatis.mapper.version.VersionUtil@nextVersion(\"").append(versionClass).append("\", ").append(column.getProperty()).append(")},");
                    continue;
                }
                if (notNull && !customIgnore) {
                    sql.append(SqlHelper.getIfNotNull((String)entityName, (EntityColumn)column, (String)(column.getColumnEqualsHolder(entityName) + ","), (boolean)notEmpty));
                    continue;
                }
                sql.append(column.getColumnEqualsHolder(entityName) + ",");
                continue;
            }
            if (!column.isId()) continue;
            sql.append(column.getColumn()).append(" = ").append(column.getColumn()).append(",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String insertIgnoreIntoTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT IGNORE INTO ");
        sql.append(TkSqlHelper.getDynamicTableName(entityClass, (String)defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String deleteLogicSetColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn logicDeleteColumn = null;
        for (EntityColumn column : columnSet) {
            if (column.getEntityField().isAnnotationPresent(LogicDelete.class)) {
                if (logicDeleteColumn != null) {
                    throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                logicDeleteColumn = column;
            }
            if (!column.isId() && column.isUpdatable()) {
                if (column != logicDeleteColumn) continue;
                LogicDelete logicDelete = (LogicDelete)logicDeleteColumn.getEntityField().getAnnotation(LogicDelete.class);
                sql.append(column.getColumn()).append(" = ").append(logicDelete.deletedVal()).append(",");
                continue;
            }
            if (!column.isId()) continue;
            sql.append(column.getColumn()).append(" = ").append(column.getColumn()).append(",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String updateSetColumnsIgnoreVersion(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn logicDeleteColumn = null;
        for (EntityColumn column : columnSet) {
            boolean customIgnore = false;
            if (column.getEntityField().isAnnotationPresent(SelectiveIgnore.class)) {
                customIgnore = true;
            }
            if (column.getEntityField().isAnnotationPresent(tk.mybatis.mapper.annotation.LogicDelete.class)) {
                if (logicDeleteColumn != null) {
                    throw new LogicDeleteException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                logicDeleteColumn = column;
            }
            if (column.isId() || !column.isUpdatable() || column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (column == logicDeleteColumn) {
                sql.append(TkSqlHelper.logicDeleteColumnEqualsValue((EntityColumn)column, (boolean)false)).append(",");
                continue;
            }
            if (notNull && !customIgnore) {
                sql.append(SqlHelper.getIfNotNull((String)entityName, (EntityColumn)column, (String)(column.getColumnEqualsHolder(entityName) + ","), (boolean)notEmpty));
                continue;
            }
            sql.append(column.getColumnEqualsHolder(entityName) + ",");
        }
        sql.append("</set>");
        return sql.toString();
    }
}

