/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static String doGet(String url) {
        return HttpClientUtil.doGet(url, null, null);
    }

    public static String doGetParams(String url, Map<String, String> paramMap) {
        return HttpClientUtil.doGet(url, paramMap, null);
    }

    public static String doGetHeader(String url, Map<String, String> headerMap) {
        return HttpClientUtil.doGet(url, null, headerMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> param, Map<String, String> headerMap) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            if (headerMap != null && headerMap.size() > 0) {
                for (Map.Entry<String, String> header : headerMap.entrySet()) {
                    httpGet.setHeader(header.getKey(), header.getValue());
                }
            }
            if ((response = httpclient.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (param != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
                httpPost.setEntity((HttpEntity)entity);
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String doPost(String url) {
        return HttpClientUtil.doPost(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJson(String url, String json) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostXml(String url, String xmlString) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "text/xml;charset=utf-8");
            StringEntity entity = new StringEntity(xmlString, ContentType.TEXT_XML);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }
}

