/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinYinHelper {
    private static final Logger logger = LoggerFactory.getLogger(PinYinHelper.class);
    private static final String EMPTY_STR = "";
    private static final String COMMA = ",";
    public static final String INITIAL_OTHER = "#";

    public static String transferToPinYin(String str) {
        try {
            return PinyinHelper.getShortPinyin((String)str).toUpperCase();
        }
        catch (PinyinException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return EMPTY_STR;
        }
    }

    public static String converterToFirstSpell(String chines) {
        try {
            return PinyinHelper.getShortPinyin((String)chines);
        }
        catch (PinyinException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return EMPTY_STR;
        }
    }

    public static String converterToSpell(String chines) {
        try {
            return PinyinHelper.convertToPinyinString((String)chines, (String)EMPTY_STR, (PinyinFormat)PinyinFormat.WITHOUT_TONE);
        }
        catch (PinyinException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return EMPTY_STR;
        }
    }

    public static String parsePinyinAndHead(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return str + COMMA + PinYinHelper.converterToSpell(str) + COMMA + PinYinHelper.converterToFirstSpell(str);
        }
        return EMPTY_STR;
    }

    public static String parsePinyinInitial(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            try {
                char c;
                String shortPy = PinyinHelper.getShortPinyin((String)str);
                if (StringUtils.isNotEmpty((CharSequence)shortPy) && ((c = shortPy.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                    return shortPy.substring(0, 1);
                }
            }
            catch (PinyinException e) {
                e.printStackTrace();
            }
        }
        return INITIAL_OTHER;
    }

    public static String parsePinyinInitialUpperCase(String str) {
        return PinYinHelper.parsePinyinInitial(str).toUpperCase();
    }

    public static String parsePinyinInitialLowerCase(String str) {
        return PinYinHelper.parsePinyinInitial(str).toLowerCase();
    }

    public static void main(String[] args) {
        String str = "\u963f\u83ab\u897f\u6797";
        String pinyin = PinYinHelper.parsePinyinInitial(str);
        System.out.println(str + " result \uff1a" + pinyin);
    }
}

