/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.RegexUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String NEW_LINE = "\r\n";

    public static String concatLengthChar(int length, char character) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(character);
        }
        return sb.toString();
    }

    public static String likeLR(String value) {
        return "%" + value + "%";
    }

    public static String joinOnComma(Iterable<?> iterable) {
        return StringUtils.join(iterable.iterator(), (String)COMMA);
    }

    public static String formatTemplate(String templateStr, Map<String, String> paramsMap) {
        String templateContent = templateStr;
        Set<Map.Entry<String, String>> entrySet = paramsMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (entry.getValue() == null || templateContent.indexOf(entry.getKey()) <= 0) continue;
            templateContent = templateContent.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return templateContent;
    }

    public static String toStr(Object obj) {
        String str = EMPTY;
        if (obj != null) {
            str = obj.toString();
        }
        return str;
    }

    public static String nullAsDash(String str) {
        if (str == null) {
            return "-";
        }
        return str;
    }

    public static String isNullOrBlank(Object value, Object defaultValue) {
        if (StringUtil.isNullOrBlank(value)) {
            return defaultValue.toString();
        }
        return value.toString();
    }

    public static boolean isNullOrBlank(String str) {
        return str == null || EMPTY.equals(str);
    }

    public static boolean isNotNullOrBlank(String str) {
        return !StringUtil.isNullOrBlank(str);
    }

    public static boolean isNotNullOrBlank(Object obj) {
        return obj != null && StringUtil.isNotNullOrBlank(obj.toString());
    }

    public static String isNotNullOrBlank(Object obj, Object defaultValue) {
        return StringUtil.isNotNullOrBlank(obj) ? obj.toString() : defaultValue.toString();
    }

    public static boolean isNullOrBlank(Object obj) {
        return obj == null || StringUtil.isNullOrBlank(obj.toString());
    }

    public static String[] strLengthSplit(String sourceStr, int length) {
        if (StringUtil.isNullOrBlank(sourceStr)) {
            return new String[]{EMPTY, EMPTY};
        }
        int sp = length * 2;
        int indexCount = 0;
        int index = 0;
        char[] chars = sourceStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            indexCount = RegexUtil.isChinese(c) ? (indexCount += 2) : ++indexCount;
            if (indexCount <= sp) continue;
            index = i;
            break;
        }
        String[] returnStr = new String[]{EMPTY, EMPTY};
        if (index > 0) {
            returnStr[0] = sourceStr.substring(0, index);
            returnStr[1] = sourceStr.substring(index);
        } else {
            returnStr[0] = sourceStr;
            returnStr[1] = EMPTY;
        }
        return returnStr;
    }

    public static void main(String[] args) {
        String templateStr = "{\u59d3\u540d}\u4eca\u5e74{\u5c81}\u5566\uff01";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("\u59d3\u540d", "\u738b\u4e8c\u5c0f");
        paramMap.put("\u5c81", "3");
        System.out.println(StringUtil.formatTemplate(templateStr, paramMap));
    }
}

