/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util.redis;

import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.redis.ZSetItem;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    private static final String LOCK_KEY_PREFIX = "REDIS_LOCK:";
    private static final int DEFAULT_TIME_OUT = 60000;

    public String get(String key) {
        String strValue = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        return strValue;
    }

    public void set(String key, String value, Long timeout, TimeUnit unit) {
        if (log.isDebugEnabled()) {
            log.debug("{}|{}|{}|{}|{}", new Object[]{"set\u65b9\u6cd5\u5165\u53c2\uff1a", "\u952e:" + key, "\u503c:" + value, "\u5b58\u6d3b\u65f6\u95f4:" + timeout, "\u65f6\u95f4\u5355\u4f4d:" + (Object)((Object)unit)});
        }
        if (timeout != null) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout.longValue(), unit != null ? unit : TimeUnit.SECONDS);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        }
    }

    public void set(String key, String value, long timeout) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K-V\uff1a " + key + "=" + value);
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
    }

    public void set(String key, String value) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K-V\uff1a " + key + "=" + value);
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void delete(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public String listLeftPop(String key, long timeout) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        return (String)this.redisTemplate.opsForList().leftPop((Object)key, timeout, TimeUnit.SECONDS);
    }

    public Long listLeftPush(String key, String value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public Long listLeftPushAll(String key, Collection<String> values) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, values);
    }

    public String listRightPop(String key, long timeout) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key, timeout, TimeUnit.SECONDS);
    }

    public String listRightPop(String key) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public <T> T listRightPop2Object(String key, Class<T> clazz) {
        try {
            String strValue = (String)this.redisTemplate.opsForList().rightPop((Object)key);
            if (StringUtils.isNotEmpty((CharSequence)strValue)) {
                return (T)JSON.parseObject((String)strValue, clazz);
            }
            return null;
        }
        catch (Exception e) {
            log.error("Json\u8f6c\u5bf9\u8c61\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    public Long listRightPush(String key, String value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public Long listRightPushAll(String key, Collection<String> values) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    public String setPop(String key) {
        return (String)this.redisTemplate.opsForSet().pop((Object)key);
    }

    public Long setAdd(String key, String ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Long setRemove(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public Set<String> setDistinctRandomMembers(String key, long count) {
        return this.redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
    }

    public <T> T hashGet(String key, String hashKey, Class<T> clazz) {
        String o = (String)this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        return (T)JSON.parseObject((String)o, clazz);
    }

    public List<Object> hashMultiGet(String key, Collection<Object> hashKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hashKeys);
    }

    public Map<Object, Object> hashGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void hashPut(String key, Object hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, (Object)JSON.toJSONString((Object)value));
    }

    public void hashPut(String key, Object hashKey, Object value, long outTime) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, (Object)JSON.toJSONString((Object)value));
    }

    public void hashPutAll(String key, Map<Object, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Long hashDelete(String key, String ... hashKeys) {
        Long counts;
        if (hashKeys.length > 1) {
            Object[] objKeys = (Object[])hashKeys.clone();
            counts = this.redisTemplate.opsForHash().delete((Object)key, objKeys);
        } else {
            counts = this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKeys[0]});
        }
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        return counts;
    }

    public boolean hashHasKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    public Long hashSize(String key) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public Boolean zSetAdd(String key, String value, double score) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key + "\u503c\uff1a " + value + "");
        return this.redisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public Set<String> zSetReverseRangeLimit(String key, long limit) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, 0L, limit);
    }

    public ZSetOperations<String, String> opsForZset() {
        return this.redisTemplate.opsForZSet();
    }

    public ValueOperations<String, String> opsForValue() {
        return this.redisTemplate.opsForValue();
    }

    public HashOperations<String, Object, Object> opsForHash() {
        return this.redisTemplate.opsForHash();
    }

    public ListOperations<String, String> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public SetOperations<String, String> opsForSet() {
        return this.redisTemplate.opsForSet();
    }

    public GeoOperations<String, String> opsForGeo() {
        return this.redisTemplate.opsForGeo();
    }

    public Long zSetRemove(String key, Object ... values) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key + "\u503c\uff1a " + Arrays.toString(values) + "");
        return this.redisTemplate.opsForZSet().remove((Object)key, values);
    }

    public Set<String> zSetRange(String key, long start, long end) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<String> zSetRangeByLex(String key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().rangeByLex((Object)key, range, limit);
    }

    public Set<String> zSetRangeByScore(String key, double min, double max, long offset, long count) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, min, max, offset, count);
    }

    public Set<String> zSetReverseRange(String key, long start, long end) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
    }

    public Set<String> zSetReverseRangeByScore(String key, double min, double max, long offset, long count) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, offset, count);
    }

    public Long zSetReverseRank(String key, String member) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        return this.redisTemplate.opsForZSet().reverseRank((Object)key, (Object)member);
    }

    public Long zSetRank(String key, String member) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().rank((Object)key, (Object)member);
    }

    public Double zSetScore(String key, String member) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().score((Object)key, (Object)member);
    }

    public Double zSetIncrementScore(String key, String member, double deal) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, (Object)member, deal);
    }

    public List<ZSetItem> zSetRangeWithScores(String key, long start, long end) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        Set sset = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
        return this.buildZsetList(Objects.requireNonNull(sset));
    }

    public List<ZSetItem> zSetRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key + ",min:" + min + ",max:" + max + ",offset:" + offset + ",count:" + count);
        Set sset = this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max, offset, count);
        if (sset == null) {
            return new ArrayList<ZSetItem>();
        }
        return this.buildZsetList(sset);
    }

    public List<ZSetItem> zSetReverseRangeWithScores(String key, long start, long end) {
        Set sset;
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        if ((sset = this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end)) == null) {
            return new ArrayList<ZSetItem>();
        }
        return this.buildZsetList(sset);
    }

    public Boolean hasKey(String key) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.hasKey((Object)key);
    }

    public Long zSetZCard(String key) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForZSet().zCard((Object)key);
    }

    public Long listSize(String key) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public List<String> listRange(String key, long start, long end) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + key);
        }
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public List<String> listRangeAndRemove(final String key, final long start, final long end) {
        SessionCallback<List<String>> sessionCallback = new SessionCallback<List<String>>(){

            public List<String> execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                RedisUtils.this.redisTemplate.opsForList().range((Object)key, start, end);
                RedisUtils.this.redisTemplate.opsForList().trim((Object)key, end + 1L, -1L);
                List exec = operations.exec();
                return (List)exec.get(0);
            }
        };
        return (List)this.redisTemplate.execute((SessionCallback)sessionCallback);
    }

    public Boolean setNx(String key, String value, long timeout) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
    }

    public Set<String> deleteKeysInPattern(String pattern) {
        log.debug("{}|{}|{}", new Object[]{"\u83b7\u53d6\u6240\u6709\u5339\u914dpattern\u53c2\u6570\u7684Keys", "[KEYS pattern]:", pattern});
        Set keySets = this.redisTemplate.keys((Object)pattern);
        if (CollectionUtils.isNotEmpty((Collection)keySets)) {
            this.redisTemplate.delete((Collection)keySets);
        }
        return keySets;
    }

    private List<ZSetItem> buildZsetList(Set<ZSetOperations.TypedTuple<String>> zset) {
        ArrayList<ZSetItem> result = new ArrayList<ZSetItem>();
        for (ZSetOperations.TypedTuple<String> stringTypedTuple : zset) {
            ZSetItem item = new ZSetItem();
            String value = (String)stringTypedTuple.getValue();
            Double score = stringTypedTuple.getScore();
            item.setValue(value);
            item.setScore(score);
            result.add(item);
        }
        return result;
    }

    public Long increment(String key, long delta) {
        log.debug("{}|{}|{}", new Object[]{"increment\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\uff1a", "key:" + key, "delta:" + delta});
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)key, timeUnit);
    }

    public Long increment(final String key, final long delta, final long timeOut) {
        log.debug("{}|{}|{}|{}", new Object[]{"increment And Expire \u63a5\u53e3\u5f00\u59cb\u8c03\u7528\uff1a", "key:" + key, "delta:" + delta, "timeOut:" + timeOut});
        SessionCallback<Long> sessionCallback = new SessionCallback<Long>(){

            public Long execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                RedisUtils.this.redisTemplate.opsForValue().increment((Object)key, delta);
                List exec = operations.exec();
                Long incValue = (Long)exec.get(0);
                if (incValue != null && incValue == 1L) {
                    RedisUtils.this.redisTemplate.expire((Object)key, timeOut, TimeUnit.SECONDS);
                }
                return incValue;
            }
        };
        return (Long)this.redisTemplate.execute((SessionCallback)sessionCallback);
    }

    public Boolean expire(String key, long timeout, TimeUnit timeUnit) {
        log.debug("{}|{}|{}|{}", new Object[]{"expire\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\uff1a", "key:" + key, "timeout:" + timeout, "timeUnit:" + (Object)((Object)timeUnit)});
        return this.redisTemplate.expire((Object)key, timeout, timeUnit);
    }

    public Set<String> getMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public Long zSetAdd(String key, Set<ZSetOperations.TypedTuple<String>> typedTuples) {
        return this.redisTemplate.opsForZSet().add((Object)key, typedTuples);
    }

    public Long zSetRemoveRangeByScore(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public Long zSetRemoveRange(String key, Long start, Long end) {
        long startValue = start != null ? start : 0L;
        long endValue = end != null ? end : -1L;
        return this.redisTemplate.opsForZSet().removeRange((Object)key, startValue, endValue);
    }

    public Set<String> keys(String pattern) {
        log.debug("\u63a5\u53e3\u8c03\u7528\u8be6\u60c5\uff1a\u53c2\u6570K\uff1a " + pattern);
        return this.redisTemplate.keys((Object)pattern);
    }

    public String lock(String lockKey) {
        return this.lock(lockKey, 60000L);
    }

    public String lock(String lockKey, long milliSecond) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new ServiceException("lockKey must not be null .");
        }
        assert (milliSecond > 1000L);
        String lockId = UUID.randomUUID().toString();
        Boolean success = this.redisTemplate.opsForValue().setIfAbsent((Object)(LOCK_KEY_PREFIX + lockKey), (Object)lockId, milliSecond, TimeUnit.MILLISECONDS);
        if (success != null && success.booleanValue()) {
            return lockId;
        }
        return null;
    }

    public void unLock(String lockKey, String lockId) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)lockId)) {
            return;
        }
        String currentLockId = (String)this.redisTemplate.opsForValue().get((Object)(LOCK_KEY_PREFIX + lockKey));
        if (currentLockId != null && currentLockId.equals(lockId)) {
            this.redisTemplate.delete((Object)(LOCK_KEY_PREFIX + lockKey));
        }
    }
}

