/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.model.PageData;
import cn.acyou.leo.framework.model.PageSo;
import cn.acyou.leo.framework.util.BeanCopyUtil;
import cn.acyou.leo.framework.util.SqlUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.data.domain.Page;

public class PageQuery {
    public static <T> PageData<T> convert(Page<T> springPage) {
        Integer pageNum = springPage.getNumber() != 0 ? springPage.getNumber() : 1;
        PageData resultData = new PageData(pageNum, Integer.valueOf(springPage.getSize()));
        resultData.setTotal(Long.valueOf(springPage.getTotalElements()));
        resultData.setList(springPage.getContent());
        resultData.setTotalPage(Integer.valueOf(springPage.getTotalPages()));
        return resultData;
    }

    public static <T> PageData<T> convert(PageInfo<T> pageInfo) {
        Integer pageNum = pageInfo.getPageNum() != 0 ? pageInfo.getPageNum() : 1;
        PageData resultData = new PageData(pageNum, Integer.valueOf(pageInfo.getPageSize()));
        resultData.setTotal(Long.valueOf(pageInfo.getTotal()));
        resultData.setList(pageInfo.getList());
        resultData.setTotalPage(Integer.valueOf(pageInfo.getPages()));
        return resultData;
    }

    public static <E, T> PageData<T> convert(PageInfo<E> pageInfo, Class<T> tarClass) {
        Integer pageNum = pageInfo.getPageNum() != 0 ? pageInfo.getPageNum() : 1;
        PageData resultData = new PageData(pageNum, Integer.valueOf(pageInfo.getPageSize()));
        resultData.setTotal(Long.valueOf(pageInfo.getTotal()));
        resultData.setList(BeanCopyUtil.copyList(pageInfo.getList(), tarClass));
        resultData.setTotalPage(Integer.valueOf(pageInfo.getPages()));
        return resultData;
    }

    public static <T> PageData<T> convert(List<T> dataList) {
        PageInfo pageInfo = new PageInfo(dataList);
        return PageQuery.convert(pageInfo);
    }

    public static PageQuery startPage(Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageQuery();
    }

    public static PageQuery startPage(Integer pageNum, Integer pageSize, Boolean pageSizeZero) {
        PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)true, null, (Boolean)pageSizeZero);
        return new PageQuery();
    }

    public static PageQuery startPage(Integer pageNum, Integer pageSize, String orderBy) {
        PageHelper.startPage((int)pageNum, (int)pageSize, (String)orderBy);
        return new PageQuery();
    }

    public static PageQuery startPage(PageSo pageSo) {
        return PageQuery.startPage(pageSo.getPageNum(), pageSo.getPageSize(), SqlUtil.convertOrderBy(pageSo));
    }

    public static PageQuery startPage(PageSo pageSo, Boolean pageSizeZero) {
        PageHelper.startPage((int)pageSo.getPageNum(), (int)pageSo.getPageSize(), (boolean)true, null, (Boolean)pageSizeZero);
        PageHelper.orderBy((String)SqlUtil.convertOrderBy(pageSo));
        return new PageQuery();
    }

    public <T> PageData<T> selectMapper(List<T> queryList) {
        PageInfo pageInfo = new PageInfo(queryList);
        return PageQuery.convert(pageInfo);
    }

    public <E, T> PageData<T> selectMapper(List<E> queryList, Class<T> tarClass) {
        PageInfo pageInfo = new PageInfo(queryList);
        return PageQuery.convert(pageInfo, tarClass);
    }
}

