/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.mybatis;

import cn.acyou.leo.framework.exception.ModifiedByAnotherUserException;
import cn.acyou.leo.framework.exception.RemovedByAnotherUserException;
import cn.acyou.leo.framework.util.ReflectUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OptimistLockCheckInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OptimistLockCheckInterceptor.class);
    private static final String SUCCESS_FLAG = "1";
    private static final String ERROR_FLAG = "0";

    public Object intercept(Invocation invocation) throws Throwable {
        Object parameterObject;
        Class<?> entityClass;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if ((SqlCommandType.UPDATE == mappedStatement.getSqlCommandType() || SqlCommandType.DELETE == mappedStatement.getSqlCommandType()) && invocation.getArgs().length > 1 && (entityClass = (parameterObject = invocation.getArgs()[1]).getClass()).isAnnotationPresent(Table.class)) {
            Table annotation = entityClass.getAnnotation(Table.class);
            String tableName = annotation.name();
            Field idField = ReflectUtils.recursiveFieldFinder(entityClass, Id.class);
            Field versionEntityField = ReflectUtils.recursiveFieldFinder(entityClass, Version.class);
            if (idField != null && versionEntityField != null) {
                String idColumnName = idField.getAnnotation(Column.class).name();
                String versionColumnName = versionEntityField.getAnnotation(Column.class).name();
                Object idColumnValue = ReflectUtils.getFieldValue(parameterObject, idField);
                Object versionColumnValue = ReflectUtils.getFieldValue(parameterObject, versionEntityField);
                if (!"".equals(idColumnName) && !"".equals(versionColumnName) && idColumnValue != null && versionColumnValue != null) {
                    Executor executor = (Executor)invocation.getTarget();
                    Connection connection = executor.getTransaction().getConnection();
                    Object databaseVersionCheck = null;
                    PreparedStatement stmt = connection.prepareStatement(String.format("SELECT %s = ? FROM %s WHERE %s = ?", versionColumnName, tableName, idColumnName));
                    stmt.setObject(1, versionColumnValue);
                    stmt.setObject(2, idColumnValue);
                    log.info(stmt.toString());
                    stmt.execute();
                    ResultSet rs = stmt.getResultSet();
                    if (rs.first()) {
                        databaseVersionCheck = rs.getObject(1);
                        rs.close();
                    }
                    stmt.close();
                    if (databaseVersionCheck == null) {
                        throw new RemovedByAnotherUserException();
                    }
                    if (ERROR_FLAG.equals(databaseVersionCheck.toString())) {
                        throw new ModifiedByAnotherUserException();
                    }
                    if (SqlCommandType.UPDATE == mappedStatement.getSqlCommandType()) {
                        Integer version = Integer.parseInt(versionColumnValue.toString()) + 1;
                        ReflectUtils.setFieldValue(versionColumnName, parameterObject, (Object)version);
                    }
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

