/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.OptionalDouble;

public class MathUtil {
    public static final BigDecimal HUNDRED = new BigDecimal("100");
    public static final BigDecimal PERCENT = new BigDecimal("0.01");

    public static Integer calculationPercent(Integer molecule, Integer denominator) {
        BigDecimal moleculeDecimal = new BigDecimal(molecule);
        BigDecimal denominatorDecimal = new BigDecimal(denominator);
        BigDecimal divide = moleculeDecimal.divide(denominatorDecimal, 2, RoundingMode.HALF_UP);
        return divide.multiply(HUNDRED).intValue();
    }

    public static Double averageDouble(Collection<Object> sourceNumbers) {
        OptionalDouble average = Arrays.stream(sourceNumbers.toArray()).mapToDouble(o -> Double.parseDouble(o.toString())).average();
        if (average.isPresent()) {
            return average.getAsDouble();
        }
        throw new IllegalArgumentException("calculation average faild !");
    }

    public static Double averageDouble(Object[] sourceNumbers) {
        return MathUtil.averageDouble(Arrays.asList(sourceNumbers));
    }

    public static long createMaxLong(int length) {
        if (length == 0) {
            return 0L;
        }
        if (length > 18) {
            throw new IllegalArgumentException("length must be less than 18 .");
        }
        return Long.parseLong(StringUtil.concatLengthChar(length, '9'));
    }

    public static void main(String[] args) {
        System.out.println(MathUtil.calculateQy(2, 0));
        System.out.println(MathUtil.calculateQy(3, 2));
        System.out.println(MathUtil.calculateQy(19, 3));
        System.out.println(MathUtil.calculateQy(0, 19));
    }

    public static Integer calculateQy(Integer currentNum, Integer lastNum) {
        BigDecimal result = new BigDecimal(currentNum).subtract(new BigDecimal(lastNum));
        if (lastNum == 0) {
            return 0;
        }
        BigDecimal multiply = result.divide(new BigDecimal(lastNum), 2, RoundingMode.UP).multiply(HUNDRED);
        return multiply.intValue();
    }
}

