/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.model.PageSo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SqlUtil {
    public static String convertOrderBy(PageSo pageSo) {
        ArrayList<String> orderBySqlList = new ArrayList<String>();
        Map supportFieldMap = pageSo.supportField();
        String sortsStr = pageSo.getSorts();
        boolean illegalOrderBy = false;
        if (StringUtils.isNotEmpty((CharSequence)sortsStr) && MapUtils.isNotEmpty((Map)supportFieldMap)) {
            Set supportKeys = supportFieldMap.keySet();
            String[] orderItems = sortsStr.split(",");
            if (orderItems.length % 2 == 0) {
                for (String orderItem : orderItems) {
                    String[] split = orderItem.split("-");
                    if (split.length % 2 == 0) {
                        String key = split[0];
                        String type = split[1];
                        if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)type) && supportKeys.contains(key) && SqlUtil.isOrderByType(type)) {
                            orderBySqlList.add((String)supportFieldMap.get(key) + " " + type.toLowerCase());
                            continue;
                        }
                        illegalOrderBy = true;
                        continue;
                    }
                    illegalOrderBy = true;
                }
            } else {
                illegalOrderBy = true;
            }
        }
        if (illegalOrderBy) {
            throw new ServiceException(CommonErrorEnum.E_INVALID_SORT_PARAMETER);
        }
        if (CollectionUtils.isNotEmpty(orderBySqlList)) {
            return StringUtils.join(orderBySqlList, (String)", ");
        }
        return null;
    }

    public static boolean isOrderByType(String type) {
        return OrderBySymbols.asc.name().equalsIgnoreCase(type) || OrderBySymbols.desc.name().equalsIgnoreCase(type);
    }

    public static enum CompareSymbols {
        eq,
        ne,
        lt,
        gt;

    }

    public static enum OrderBySymbols {
        asc,
        desc;

    }
}

