/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.util.concurrent.TimeUnit;

public class UnitConversionUtil {
    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public static String convertTime(long duration, TimeUnit unit) {
        long seconds;
        long minutes;
        long milliseconds = TimeUnit.MILLISECONDS.convert(duration, unit);
        long hours = TimeUnit.HOURS.convert(milliseconds, TimeUnit.MILLISECONDS);
        if (hours > 0L) {
            milliseconds -= hours * 60L * 60L * 1000L;
        }
        if ((minutes = TimeUnit.MINUTES.convert(milliseconds, TimeUnit.MILLISECONDS)) > 0L) {
            milliseconds -= minutes * 60L * 1000L;
        }
        if ((seconds = TimeUnit.SECONDS.convert(milliseconds, TimeUnit.MILLISECONDS)) > 0L) {
            milliseconds -= seconds * 1000L;
        }
        return String.format("|\u65f6:%s|\u5206:%s|\u79d2:%s|\u6beb\u79d2:%s|", hours, minutes, seconds, milliseconds);
    }
}

