/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.valid;

import cn.acyou.leo.framework.annotation.valid.BaseValid;
import cn.acyou.leo.framework.annotation.valid.DateValidType;
import cn.acyou.leo.framework.annotation.valid.EnhanceValid;
import cn.acyou.leo.framework.annotation.valid.RegexType;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.service.DictValidService;
import cn.acyou.leo.framework.util.IdCardValidUtil;
import cn.acyou.leo.framework.util.ReflectUtils;
import cn.acyou.leo.framework.util.RegexUtil;
import cn.acyou.leo.framework.util.SpringHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceValidUtil {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceValidUtil.class);

    public static void valid(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.forEach(EnhanceValidUtil::validEntity);
        } else {
            EnhanceValidUtil.validEntity(object);
        }
    }

    private static void validEntity(Object object) {
        Field[] fields;
        Class<?> clazz = object.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            EnhanceValidUtil.enhanceValidSupport(field, object);
            field.setAccessible(false);
        }
    }

    private static void enhanceValidSupport(Field field, Object object) {
        BaseValid baseValid;
        EnhanceValid enhanceValid = field.getAnnotation(EnhanceValid.class);
        if (enhanceValid != null) {
            for (BaseValid validField : baseValid = enhanceValid.value()) {
                EnhanceValidUtil.baseValidSupport(field, object, validField);
            }
        }
        if ((baseValid = field.getAnnotation(BaseValid.class)) != null) {
            EnhanceValidUtil.baseValidSupport(field, object, baseValid);
        }
    }

    private static void baseValidSupport(Field field, Object object, BaseValid baseValid) {
        Object validValue = null;
        String description = "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01";
        try {
            validValue = field.get(object);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String currentFieldName = field.getName();
        if (StringUtils.isNotEmpty((CharSequence)baseValid.message())) {
            description = baseValid.message();
        }
        if (baseValid.notNull() && (validValue == null || StringUtils.isEmpty((CharSequence)validValue.toString()))) {
            throw new ServiceException(description);
        }
        if (baseValid.notEmpty()) {
            if (validValue == null || StringUtils.isEmpty((CharSequence)validValue.toString())) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u4e3aNULL"});
                throw new ServiceException(description);
            }
            if (validValue instanceof Collection && ((Collection)validValue).isEmpty()) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u96c6\u5408\u4e3a\u7a7a"});
                throw new ServiceException(description);
            }
            if (validValue instanceof Map && ((Map)validValue).isEmpty()) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u96c6\u5408\u4e3a\u7a7a"});
                throw new ServiceException(description);
            }
        }
        if (validValue != null && !"".equals(validValue.toString())) {
            String result;
            if (validValue.toString().length() > baseValid.maxLength() && baseValid.maxLength() != 0) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u957f\u5ea6\u8d85\u8fc7\u4e86", baseValid.maxLength()});
                throw new ServiceException(description);
            }
            if (validValue.toString().length() < baseValid.minLength() && baseValid.minLength() != 0) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u957f\u5ea6\u5c0f\u4e8e\u4e86", baseValid.minLength()});
                throw new ServiceException(description);
            }
            if (baseValid.fixLength() != 0 && validValue.toString().length() < baseValid.fixLength()) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u56fa\u5b9a\u957f\u5ea6\u4e3a", baseValid.fixLength()});
                throw new ServiceException(description);
            }
            if (NumberUtils.isCreatable((String)validValue.toString()) && baseValid.min() != Integer.MIN_VALUE && Integer.parseInt(validValue.toString()) < baseValid.min()) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u4e0d\u80fd\u5c0f\u4e8e", baseValid.min()});
                throw new ServiceException(description);
            }
            if (NumberUtils.isCreatable((String)validValue.toString()) && baseValid.max() != Integer.MIN_VALUE && Integer.parseInt(validValue.toString()) > baseValid.max()) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u4e0d\u80fd\u5927\u4e8e", baseValid.max()});
                throw new ServiceException(description);
            }
            if (baseValid.notInRange().length > 0 && !ArrayUtils.contains((Object[])baseValid.notInRange(), (Object)validValue.toString())) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53d6\u503c\u4e0d\u5728\u8303\u56f4\u5185"});
                throw new ServiceException(description);
            }
            if (baseValid.numberNotInRange().length > 0 && !ArrayUtils.contains((int[])baseValid.numberNotInRange(), (int)Integer.parseInt(validValue.toString()))) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53d6\u503c\u4e0d\u5728\u8303\u56f4\u5185"});
                throw new ServiceException(description);
            }
            if (baseValid.dictCode().length() > 0) {
                String dictCode = baseValid.dictCode();
                String value = validValue.toString();
                DictValidService dictValidService = SpringHelper.getBean(DictValidService.class);
                boolean isExist = dictValidService.validDictValue(dictCode, value);
                if (!isExist) {
                    logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u6570\u636e\u5b57\u5178\u4e0d\u5728\u8303\u56f4\u5185\uff01"});
                    throw new ServiceException(description);
                }
            }
            if (baseValid.regexType() != RegexType.NONE) {
                result = null;
                switch (baseValid.regexType()) {
                    case SPECIALCHAR: {
                        if (!RegexUtil.hasSpecialChar(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u4e0d\u80fd\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff01"});
                        result = description;
                        break;
                    }
                    case CHINESE: {
                        if (!RegexUtil.isChinese2(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\u5b57\u7b26\uff01"});
                        result = description;
                        break;
                    }
                    case EMAIL: {
                        if (RegexUtil.isEmail(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u90ae\u7bb1\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case IP: {
                        if (RegexUtil.isIp(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1aIP\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case NUMBER: {
                        if (RegexUtil.isNumber(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u4e0d\u662f\u6570\u5b57\uff01"});
                        result = description;
                        break;
                    }
                    case MOBILE_PHONE: {
                        if (RegexUtil.isMobilePhone(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case MOBILEPHONE_OR_TELEPHONE: {
                        if (RegexUtil.isTelephoneOrMobilephone(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case ID_CARD: {
                        if (IdCardValidUtil.isValidatedAllIdcard(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case DATE: {
                        if (RegexUtil.isDateStr(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case DATETIME: {
                        if (RegexUtil.isDateTime(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case NUMBER_LETTER_COMBINATION: {
                        if (RegexUtil.isNumberLetter(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a(\u6570\u5b57\u4e0e\u5b57\u6bcd)\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                    case NUMBER_LETTER_SYMBOL_COMBINATION: {
                        if (RegexUtil.isNumberLetterSymbol(validValue.toString())) break;
                        logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a(\u6570\u5b57\u4e0e\u5b57\u6bcd\u4e0e\u7b26\u53f7)\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"});
                        result = description;
                        break;
                    }
                }
                if (null != result) {
                    throw new ServiceException(result);
                }
            }
            if (baseValid.dateValid() != DateValidType.none) {
                result = null;
                if (validValue instanceof Date) {
                    Date validValueDate = (Date)validValue;
                    switch (baseValid.dateValid()) {
                        case if_afterNow: {
                            if (!validValueDate.after(new Date())) break;
                            logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"});
                            result = description;
                            break;
                        }
                        case if_beforeNow: {
                            if (!validValueDate.before(new Date())) break;
                            logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"});
                            result = description;
                            break;
                        }
                        case if_afterSpecifyDate: {
                            Date filedDate;
                            Object fieldValue;
                            String afterDateFieldName = baseValid.specifyDateFieldName();
                            if (afterDateFieldName.trim().length() <= 0 || !((fieldValue = ReflectUtils.getFieldValue(object, afterDateFieldName)) instanceof Date) || !validValueDate.before(filedDate = (Date)fieldValue)) break;
                            logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u4e0d\u80fd\u5927\u4e8e" + afterDateFieldName + "\uff01"});
                            result = description;
                            break;
                        }
                        case if_beforeSpecifyDate: {
                            Date filedDate;
                            Object fieldValue;
                            String beforeDateFieldName = baseValid.specifyDateFieldName();
                            if (beforeDateFieldName.trim().length() <= 0 || !((fieldValue = ReflectUtils.getFieldValue(object, beforeDateFieldName)) instanceof Date) || !validValueDate.before(filedDate = (Date)fieldValue)) break;
                            logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u4e0d\u80fd\u5c0f\u4e8e" + beforeDateFieldName + "\uff01"});
                            result = description;
                            break;
                        }
                    }
                    if (null != result) {
                        throw new ServiceException(result);
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)baseValid.regexExpression()) && validValue.toString().matches(baseValid.regexExpression())) {
                logger.warn("[\u6570\u636e\u6821\u9a8c]|{}|{}|{}", new Object[]{"valid failed", currentFieldName, "\u683c\u5f0f\u4e0d\u6b63\u786e"});
                throw new ServiceException(description);
            }
            if (baseValid.entityValid()) {
                EnhanceValidUtil.valid(validValue);
            }
            if (baseValid.entityCollectionValid() && validValue instanceof Collection) {
                Collection valueList = (Collection)validValue;
                for (Object o : valueList) {
                    EnhanceValidUtil.valid(o);
                }
            }
        }
    }
}

