/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.annotation.AccessLimit;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.Md5Util;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class AccessLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitAspect.class);
    @Autowired
    private RedisUtils redisUtils;

    @Pointcut(value="@annotation(accessLimit)")
    public void pointCut(AccessLimit accessLimit) {
    }

    @Around(value="pointCut(accessLimit)")
    public Object around(ProceedingJoinPoint joinPoint, AccessLimit accessLimit) throws Throwable {
        Boolean aBoolean;
        long accessInterval = accessLimit.interval();
        boolean includeArgs = accessLimit.includeArgs();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (requestAttributes != null);
        HttpServletRequest request = requestAttributes.getRequest();
        String path = request.getServletPath();
        String token = request.getHeader("Authentication");
        StringBuilder keyBuffer = new StringBuilder(path);
        if (StringUtils.hasText((String)token)) {
            keyBuffer.append(token);
        }
        HashMap<Integer, Object> paramsMap = new HashMap<Integer, Object>();
        if (includeArgs) {
            Object[] args = joinPoint.getArgs();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg instanceof ServletRequest || arg instanceof ServletResponse || arg instanceof MultipartFile) continue;
                paramsMap.put(i, arg);
            }
            keyBuffer.append("ARGS:");
            keyBuffer.append(Md5Util.md5(JSON.toJSONString(paramsMap)));
        }
        if (!(aBoolean = this.redisUtils.setIfAbsent(keyBuffer.toString(), "1", accessInterval, TimeUnit.MILLISECONDS)).booleanValue()) {
            return Result.error((ErrorEnum)CommonErrorEnum.ACCESS_LIMIT);
        }
        return joinPoint.proceed();
    }
}

