/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.cache;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;

public class CustomizeRedisCache
extends RedisCache {
    private final RedisCacheWriter redisCacheWriter;
    private final RedisCacheConfiguration configuration;
    private static final String SPLITTER = "#";

    protected CustomizeRedisCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(name, cacheWriter, cacheConfig);
        this.redisCacheWriter = cacheWriter;
        this.configuration = cacheConfig;
    }

    public void put(Object key, Object value) {
        String name = super.getName();
        if (name.contains(SPLITTER)) {
            List<String> keyList = Arrays.asList(name.split(SPLITTER));
            if (keyList.size() != 2) {
                throw new IllegalArgumentException("@Cacheable value = " + name + " not Allow !");
            }
            String finalName = keyList.get(0);
            String expireName = keyList.get(1);
            if (!NumberUtils.isCreatable((String)expireName)) {
                throw new IllegalArgumentException("@Cacheable value = " + name + " not Allow ! ttl invalid");
            }
            long ttl = Long.parseLong(expireName);
            Object cacheValue = this.preProcessCacheValue(value);
            if (!this.isAllowNullValues() && cacheValue == null) {
                throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", name));
            }
            this.redisCacheWriter.put(finalName, this.serializeCacheKey(this.createCacheKey(key)), this.serializeCacheValue(cacheValue), Duration.ofSeconds(ttl));
        } else {
            super.put(key, value);
        }
    }

    protected String createCacheKey(Object key) {
        String convertedKey = this.convertKey(key);
        if (!this.configuration.usePrefix()) {
            return convertedKey;
        }
        return this.prefixCacheKey(convertedKey);
    }

    private String prefixCacheKey(String key) {
        String name = super.getName();
        if (name.contains(SPLITTER)) {
            List<String> keyList = Arrays.asList(name.split(SPLITTER));
            String finalName = keyList.get(0);
            return this.configuration.getKeyPrefixFor(finalName) + key;
        }
        return this.configuration.getKeyPrefixFor(name) + key;
    }
}

