/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader;

import cn.acyou.leo.framework.downloader.ext.ByteArrayResponseExtractor;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import cn.acyou.leo.framework.downloader.utils.RestTemplateBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class DownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtil.class);
    private static final RestTemplate restTemplate = RestTemplateBuilder.builder().build();
    private static final DownloadProgressPrinter downloadProgressPrinter = DownloadProgressPrinter.defaultDownloadProgressPrinter();

    private DownloadUtil() {
    }

    public static void downloadDir(String fileURL, String dir) throws Exception {
        String urlResourcesName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
        DownloadUtil.download(fileURL, dir + File.separator + urlResourcesName);
    }

    public static void downloadFile(String fileURL, String dir, String fileName) throws Exception {
        DownloadUtil.download(fileURL, dir + File.separator + fileName);
    }

    public static void download(String fileURL, String fileFullPath) throws Exception {
        DownloadUtil.download(fileURL, fileFullPath, null);
    }

    public static void download(String fileURL, String fileFullPath, Map<String, String> headerMaps) throws Exception {
        File file = new File(fileFullPath);
        boolean mkdirs = file.getParentFile().mkdirs();
        if (mkdirs) {
            log.info("auto create directory \uff1a{}", (Object)file.getParentFile().getAbsolutePath());
        }
        HttpHeaders headers = new HttpHeaders();
        if (headerMaps != null && headerMaps.size() > 0) {
            headerMaps.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ByteArrayResponseExtractor byteArrayResponseExtractor = new ByteArrayResponseExtractor(downloadProgressPrinter);
        RequestCallback requestCallback = restTemplate.httpEntityCallback((Object)requestEntity, ByteArrayResponseExtractor.class);
        byte[] body = (byte[])restTemplate.execute(fileURL, HttpMethod.GET, requestCallback, (ResponseExtractor)byteArrayResponseExtractor, new Object[0]);
        Files.write(Paths.get(fileFullPath, new String[0]), Objects.requireNonNull(body), new OpenOption[0]);
    }
}

