/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.service;

import cn.acyou.leo.framework.mapper.Mapper;
import cn.acyou.leo.framework.service.Service;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

public class ServiceImpl<M extends Mapper<T>, T>
implements Service<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceImpl.class);
    @Autowired
    protected M baseMapper;
    private final Class<T> clazz;

    public ServiceImpl() {
        TypeToken poType = new TypeToken<T>(this.getClass()){};
        this.clazz = poType.getRawType();
    }

    public Example.Builder builderExample() {
        return Example.builder(this.clazz);
    }

    public Example buildWhereSqlsExample(Sqls sqls) {
        return this.builderExample().where(sqls).build();
    }

    public Example buildOrderByAscWhereSqlsExample(Sqls sqls, String orderByProperties) {
        return this.builderExample().orderByAsc(new String[]{orderByProperties}).where(sqls).build();
    }

    public Example buildOrderByDescWhereSqlsExample(Sqls sqls, String orderByProperties) {
        return this.builderExample().orderByDesc(new String[]{orderByProperties}).where(sqls).build();
    }

    @Override
    public int insert(T record) {
        return this.baseMapper.insert(record);
    }

    @Override
    public int insertSelective(T record) {
        return this.baseMapper.insertSelective(record);
    }

    @Override
    public int insertList(List<T> recordList) {
        return this.baseMapper.insertList(recordList);
    }

    @Override
    public int insertListSelective(List<T> recordList) {
        return this.baseMapper.insertListSelective(recordList);
    }

    @Override
    public int updateListSelective(Collection<T> recordList) {
        return this.baseMapper.updateListSelective(recordList);
    }

    @Override
    public int updateList(Collection<T> recordList) {
        return this.baseMapper.updateList(recordList);
    }

    @Override
    public int updateByExample(T record, Object example) {
        return this.baseMapper.updateByExample(record, example);
    }

    @Override
    public int updateByExampleSelective(T record, Object example) {
        return this.baseMapper.updateByExampleSelective(record, example);
    }

    @Override
    public int updateByExampleSelectiveCustom(T record, Object example) {
        return this.baseMapper.updateByExampleSelectiveCustom(record, example);
    }

    @Override
    public int updateByPrimaryKey(T record) {
        return this.baseMapper.updateByPrimaryKey(record);
    }

    @Override
    public int updateByPrimaryKeySelective(T record) {
        return this.baseMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKeySelectiveCustom(T record) {
        return this.baseMapper.updateByPrimaryKeySelectiveCustom(record);
    }

    @Override
    public <E> int deleteByPrimaryKeyList(Collection<E> idList) {
        return this.baseMapper.deleteByPrimaryKeyList(idList);
    }

    @Override
    public int delete(T record) {
        return this.baseMapper.delete(record);
    }

    @Override
    public int deleteByPrimaryKey(Object key) {
        return this.baseMapper.deleteByPrimaryKey(key);
    }

    @Override
    public int deleteByExample(Object example) {
        return this.baseMapper.deleteByExample(example);
    }

    @Override
    public int delete(String ids) {
        return this.baseMapper.deleteByIds(ids);
    }

    @Override
    public <E> List<T> selectByPrimaryKeyList(Collection<E> idList) {
        return this.baseMapper.selectByPrimaryKeyList(idList);
    }

    @Override
    public List<T> select(T record) {
        return this.baseMapper.select(record);
    }

    @Override
    public List<T> selectByExample(Object example) {
        return this.baseMapper.selectByExample(example);
    }

    @Override
    public List<T> selectAll() {
        return this.baseMapper.selectAll();
    }

    @Override
    public List<T> selectByIds(String ids) {
        return this.baseMapper.selectByIds(ids);
    }

    @Override
    public int selectCount(T record) {
        return this.baseMapper.selectCount(record);
    }

    @Override
    public int selectCountByExample(Object example) {
        return this.baseMapper.selectCountByExample(example);
    }

    @Override
    public T selectByPrimaryKey(Object key) {
        return (T)this.baseMapper.selectByPrimaryKey(key);
    }

    @Override
    public T selectOne(T record) {
        return (T)this.baseMapper.selectOne(record);
    }

    @Override
    public T selectOneByExample(Object example) {
        return (T)this.baseMapper.selectOneByExample(example);
    }

    @Override
    public List<T> selectByProperties(String propertyName, Object value, Object ... args) {
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return new ArrayList();
        }
        Sqls sqls = Sqls.custom();
        sqls.andEqualTo(propertyName, value);
        int groupLen = 2;
        if (args != null && args.length % groupLen == 0) {
            for (int i = 0; i < args.length; i += groupLen) {
                sqls.andEqualTo(String.valueOf(args[i]), args[i + 1]);
            }
        }
        Example example = this.builderExample().where(sqls).build();
        return this.baseMapper.selectByExample((Object)example);
    }
}

