/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UrlUtil {
    public static final String SLASH = "\\";

    public static String getQueryString(String url, String key) {
        Map<String, String> paramsMap = UrlUtil.getQueryString(url);
        return paramsMap.get(key) != null ? paramsMap.get(key) : "";
    }

    public static String getJsonPJsonStr(String jsonpStr) {
        int startIndex = jsonpStr.indexOf("(");
        int endIndex = jsonpStr.lastIndexOf(")");
        return jsonpStr.substring(startIndex + 1, endIndex);
    }

    public static String getAppointJsonStr(String jsonStr, String key) {
        JSONObject obj = JSONObject.parseObject((String)jsonStr);
        Object o = obj.get((Object)key);
        if (o != null) {
            return JSON.toJSONString((Object)o);
        }
        return "";
    }

    public static Map<String, String> getQueryString(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        int start = url.indexOf("?");
        if (start >= 0) {
            String[] paramsArr;
            String str = url.substring(start + 1);
            for (String param : paramsArr = str.split("&")) {
                String[] temp = param.split("=");
                map.put(temp[0], temp[1]);
            }
        }
        return map;
    }

    public static String getQueryStringFromPath(String url) {
        int start = url.lastIndexOf("/") + 1;
        if (url.lastIndexOf("?") == -1) {
            return url.substring(start);
        }
        return url.substring(start, url.lastIndexOf("?"));
    }

    public static String replaceUrlParams(String url, Map<String, String> newParams) {
        String newUrl = url;
        for (Map.Entry<String, String> entry : newParams.entrySet()) {
            Pattern pattern = Pattern.compile("([?&])" + entry.getKey() + "=([^&]+)");
            Matcher matcher = pattern.matcher(newUrl);
            if (!matcher.find()) continue;
            String group = matcher.group(0);
            if (group.startsWith("?")) {
                newUrl = matcher.replaceAll("?" + entry.getKey() + "=" + entry.getValue());
            }
            if (!group.startsWith("&")) continue;
            newUrl = matcher.replaceAll("&" + entry.getKey() + "=" + entry.getValue());
        }
        return newUrl;
    }

    public static String replaceUrlParams(String url, String ... params) {
        HashMap<String, String> newParamsMap = new HashMap<String, String>();
        int length = params.length;
        if (length == 0) {
            return url;
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u5947\u6570");
        }
        for (int i = 0; i < params.length; i += 2) {
            newParamsMap.put(params[i], params[i + 1]);
        }
        return UrlUtil.replaceUrlParams(url, newParamsMap);
    }

    public static String append(String url, String ... params) {
        ArrayList<String> paramList = new ArrayList<String>();
        int length = params.length;
        if (length == 0) {
            return url;
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u5947\u6570");
        }
        for (int i = 0; i < params.length; i += 2) {
            paramList.add("&" + params[i] + "=" + params[i + 1]);
        }
        if (url.endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!url.contains("?")) {
            url = url.concat("?");
        }
        return url + StringUtils.join(paramList, (String)"");
    }

    public static String append(String url, Map<String, ?> params) {
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            url = UrlUtil.append(url, entry.getKey(), entry.getValue().toString());
        }
        return url;
    }

    public static String getPathName(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getPath();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static String getSearch(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getQuery();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static void main(String[] args) {
        String url = "https://sou.zhaopin.com/?jl=635&kw=\u7f16\u5bfc&kt=3";
        System.out.println(UrlUtil.replaceUrlParams(url, "kt", "GGG"));
    }
}

