/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.prop.LeoProperty;
import com.alibaba.fastjson.JSON;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Aspect
@Component
public class ParameterRecordAspect {
    private static final Logger log = LoggerFactory.getLogger(ParameterRecordAspect.class);
    @Autowired
    private LeoProperty leoProperty;

    @Pointcut(value="execution(* cn.acyou.leo.*.controller.*..*(..))")
    public void parameterValid() {
    }

    @Before(value="parameterValid()")
    public void before(JoinPoint jp) {
        MethodSignature methodSignature = (MethodSignature)jp.getSignature();
        Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
        Object[] args = jp.getArgs();
        LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
        for (Annotation[] parameterAnnotation : parameterAnnotations) {
            int paramIndex = ArrayUtils.indexOf((Object[])parameterAnnotations, (Object)parameterAnnotation);
            List annotations = Arrays.stream(parameterAnnotation).map(Annotation::annotationType).collect(Collectors.toList());
            for (Annotation annotation : parameterAnnotation) {
                Object paramValue;
                if (annotation instanceof RequestParam) {
                    paramValue = args[paramIndex];
                    paramsMap.put("RequestParam_" + paramIndex, paramValue);
                }
                if (annotation instanceof RequestBody) {
                    paramValue = args[paramIndex];
                    paramsMap.put("RequestBody_" + paramIndex, paramValue);
                }
                if (!(annotation instanceof PathVariable)) continue;
                paramValue = args[paramIndex];
                paramsMap.put("PathVariable_" + paramIndex, paramValue);
            }
        }
        AppContext.setRequestParams(paramsMap);
        if (this.leoProperty.isPrintRequestParam()) {
            log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}|\u53c2\u6570\uff1a{}", (Object)AppContext.getActionUrl(), (Object)JSON.toJSONString(paramsMap));
        }
    }
}

