/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.BeanUtil;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u9ed8\u8ba4\u9519\u8bef\u5904\u7406"})
@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class CustomErrorController
extends BasicErrorController {
    public CustomErrorController(ServerProperties serverProperties) {
        super((ErrorAttributes)new DefaultErrorAttributes(), serverProperties.getError());
    }

    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus httpStatus = this.getStatus(request);
        Map originalMsgMap = this.getErrorAttributes(request, ErrorAttributeOptions.defaults());
        Integer status = (Integer)originalMsgMap.get("status");
        String error = (String)originalMsgMap.get("error");
        String message = (String)originalMsgMap.get("message");
        Result resultError = Result.error((int)status, (String)(error + "|" + message));
        if (HttpStatus.NOT_FOUND.equals((Object)httpStatus)) {
            resultError = Result.error((ErrorEnum)CommonErrorEnum.E_NOT_FOUNT);
        }
        return new ResponseEntity(BeanUtil.convertToMap(resultError), httpStatus);
    }

    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        response.setStatus(this.getStatus(request).value());
        Map model = this.getErrorAttributes(request, ErrorAttributeOptions.defaults());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        return modelAndView == null ? new ModelAndView("/sys/common/error", model) : modelAndView;
    }
}

