/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.config;

import cn.acyou.leo.framework.prop.XssProperty;
import cn.acyou.leo.framework.util.StringUtils;
import cn.acyou.leo.framework.xss.XssFilter;
import java.util.HashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XssProperty.class})
public class FilterConfig {
    @Bean
    public FilterRegistrationBean<?> xssFilterRegistration(XssProperty xssProperty) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new XssFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("xssFilter");
        registration.setOrder(Integer.MAX_VALUE);
        HashMap<String, String> initParameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank(xssProperty.getExcludes())) {
            initParameters.put("excludes", xssProperty.getExcludes());
        }
        initParameters.put("enabled", String.valueOf(xssProperty.isEnabled()));
        registration.setInitParameters(initParameters);
        return registration;
    }
}

