/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader;

import cn.acyou.leo.framework.downloader.AbstractDownloader;
import cn.acyou.leo.framework.downloader.ext.FileResponseExtractor;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;

public class MultiThreadFileDownloader
extends AbstractDownloader {
    private int threadNum;

    public MultiThreadFileDownloader(int threadNum, DownloadProgressPrinter downloadProgressPrinter) {
        super(downloadProgressPrinter);
        this.threadNum = threadNum;
    }

    public MultiThreadFileDownloader(int threadNum) {
        super(DownloadProgressPrinter.defaultDownloadProgressPrinter());
        this.threadNum = threadNum;
    }

    @Override
    protected void doDownload(String fileURL, String dir, String fileName, HttpHeaders headers) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.threadNum);
        long contentLength = headers.getContentLength();
        this.downloadProgressPrinter.setContentLength(contentLength);
        long step = contentLength / (long)this.threadNum;
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (int index = 0; index < this.threadNum; ++index) {
            String start = step * (long)index + "";
            String end = index == this.threadNum - 1 ? "" : step * (long)(index + 1) - 1L + "";
            String tempFilePath = dir + File.separator + "." + fileName + ".download." + index;
            FileResponseExtractor extractor = new FileResponseExtractor(index, tempFilePath, this.downloadProgressPrinter);
            CompletionStage future2 = CompletableFuture.supplyAsync(() -> {
                RequestCallback callback = request -> request.getHeaders().add("Range", "bytes=" + start + "-" + end);
                return (File)this.restTemplate.execute(fileURL, HttpMethod.GET, callback, (ResponseExtractor)extractor, new Object[0]);
            }, executorService).exceptionally(e -> {
                e.printStackTrace();
                return null;
            });
            futures.add(future2);
        }
        String tmpFilePath = dir + File.separator + fileName + ".download";
        File file = new File(tmpFilePath);
        FileChannel outChannel = new FileOutputStream(file).getChannel();
        futures.forEach(future -> {
            try {
                File tmpFile = (File)future.get();
                FileChannel tmpIn = new FileInputStream(tmpFile).getChannel();
                outChannel.transferFrom(tmpIn, outChannel.size(), tmpIn.size());
                tmpIn.close();
                tmpFile.delete();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
        outChannel.close();
        executorService.shutdown();
        file.renameTo(new File(dir + File.separator + fileName));
    }
}

