/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.interceptor;

import cn.acyou.leo.framework.base.ClientLanguage;
import cn.acyou.leo.framework.base.InterfaceCallStatistics;
import cn.acyou.leo.framework.base.LoginUser;
import cn.acyou.leo.framework.commons.AsyncManager;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.constant.Constant;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.prop.LeoProperty;
import cn.acyou.leo.framework.util.IPUtil;
import cn.acyou.leo.framework.util.SourceUtil;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class BaseInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BaseInterceptor.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private LeoProperty leoProperty;

    protected abstract String getToken(HttpServletRequest var1);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MDC.put((String)"leoTraceNo", (String)UUID.randomUUID().toString().replaceAll("-", ""));
        String remoteIp = IPUtil.getClientIp(request);
        String localIp = IPUtil.getLocalIP();
        log.info("LeoInterceptor \u2014\u2014>  remoteIP:{}, localIP: {}, \u8bbf\u95ee\u8def\u5f84:{}", new Object[]{remoteIp, localIp, request.getRequestURI()});
        if (this.leoProperty.isTokenVerify()) {
            String token = this.getToken(request);
            if (!StringUtils.hasText((String)token)) {
                this.falseResult(response, CommonErrorEnum.E_UNAUTHENTICATED);
                return false;
            }
            String userId = this.redisUtils.get("USER:LOGIN:TOKEN:" + token);
            if (!StringUtils.hasText((String)userId)) {
                String loginAtOtherWhere = this.redisUtils.get("USER:LOGIN:LOGINATOTHERWHERE:" + token);
                if (StringUtils.hasText((String)loginAtOtherWhere)) {
                    this.falseResult(response, CommonErrorEnum.E_LOGIN_AT_OTHER_WHERE);
                } else {
                    this.falseResult(response, CommonErrorEnum.E_LOGIN_TIMEOUT);
                }
                return false;
            }
            String loginStr = this.redisUtils.get("USER:LOGIN:USER:" + userId);
            AppContext.setLoginUser((LoginUser)JSON.parseObject((String)loginStr, LoginUser.class));
        }
        AppContext.setIp(remoteIp);
        AppContext.setRequestTimeStamp(System.currentTimeMillis());
        AppContext.setActionUrl(request.getRequestURI());
        AppContext.setClientType(SourceUtil.getClientTypeByUserAgent(request));
        String language = request.getHeader("Language");
        AppContext.setClientLanguage(ClientLanguage.getLanguage(language));
        String methodInfo = "";
        String apiRemark = "";
        String debug = "true";
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            methodInfo = handlerMethod.toString();
            Method method = handlerMethod.getMethod();
            ApiOperation annotation = method.getAnnotation(ApiOperation.class);
            if (annotation != null) {
                apiRemark = annotation.value();
                Extension[] extensions = annotation.extensions();
                if (extensions != null) {
                    block0: for (Extension extension : extensions) {
                        if (extension.properties() == null) continue;
                        for (ExtensionProperty property : extension.properties()) {
                            if (!property.name().equalsIgnoreCase("debug") || !property.value().equalsIgnoreCase("false")) continue;
                            debug = "false";
                            continue block0;
                        }
                    }
                }
            }
        }
        AppContext.setActionApiOperation(new String[]{methodInfo, apiRemark, debug});
        return true;
    }

    private void falseResult(HttpServletResponse response, CommonErrorEnum commonErrorEnum) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        Result resultBody = Result.error((ErrorEnum)commonErrorEnum);
        ObjectMapper objectMapper = new ObjectMapper();
        response.getWriter().println(objectMapper.writeValueAsString((Object)resultBody));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.processInterfaceStatistics(request);
        log.info("LeoInterceptor \u2014\u2014>  \u8bbf\u95ee\u7ed3\u675f\u3002");
        AppContext.clearThreadLocal();
        PageHelper.clearPage();
        MDC.clear();
    }

    public void processInterfaceStatistics(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (!this.leoProperty.isInterfaceCallStatistics()) {
            return;
        }
        if (this.leoProperty.getIgnoreUriList().contains(requestURI)) {
            return;
        }
        if (!AppContext.getActionDebug()) {
            return;
        }
        Result<?> exceptionResult = AppContext.getExceptionResult();
        InterfaceCallStatistics interfaceCallStatistics = InterfaceCallStatistics.builder().url(requestURI).type(Constant.CONS_1).methodType(request.getMethod()).methodInfo(AppContext.getActionApiMethodInfoRemark()).methodDesc(AppContext.getActionApiOperationValue()).params(AppContext.getParamsMap() != null && AppContext.getParamsMap().size() > 0 ? JSON.toJSONString(AppContext.getParamsMap()) : null).startTime(new Date(AppContext.getRequestTimeStamp())).execTime(System.currentTimeMillis() - AppContext.getRequestTimeStamp()).errorMessage(exceptionResult != null ? exceptionResult.getMessage() : null).errorStackTrace(exceptionResult != null && exceptionResult.getData() != null ? JSON.toJSONString((Object)exceptionResult.getData()) : null).clientType(AppContext.getClientType().getMessage()).ip(AppContext.getIp()).userId(AppContext.getLoginUser() != null ? AppContext.getLoginUser().getUserId() : null).userName(AppContext.getLoginUser() != null ? AppContext.getLoginUser().getUserName() : null).build();
        AsyncManager.me().execute(() -> log.info(">>> {}", (Object)interfaceCallStatistics));
    }
}

