/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.mybatis;

import cn.acyou.leo.framework.annotation.mapper.Desensitized;
import cn.acyou.leo.framework.annotation.mapper.International;
import cn.acyou.leo.framework.annotation.mapper.SensitizedType;
import cn.acyou.leo.framework.base.ClientLanguage;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.util.DesensitizedUtil;
import cn.acyou.leo.framework.util.ReflectUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class QueryResultInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        Object returnValue = invocation.proceed();
        if (returnValue instanceof List) {
            List returnValueList = (List)returnValue;
            if (returnValueList.size() == 0) {
                return returnValue;
            }
            Class<?> resClass = returnValueList.get(0).getClass();
            Field[] declaredFields = resClass.getDeclaredFields();
            HashMap<String, String> internationalFieldMap = new HashMap<String, String>();
            HashMap<String, SensitizedType> desensitizedFieldMap = new HashMap<String, SensitizedType>();
            for (Field declaredField : declaredFields) {
                Desensitized desensitizedAnnotation;
                International annotation = declaredField.getAnnotation(International.class);
                if (annotation != null) {
                    internationalFieldMap.put(declaredField.getName(), annotation.separator());
                }
                if ((desensitizedAnnotation = declaredField.getAnnotation(Desensitized.class)) == null) continue;
                desensitizedFieldMap.put(declaredField.getName(), desensitizedAnnotation.type());
            }
            if (internationalFieldMap.isEmpty() && desensitizedFieldMap.isEmpty()) {
                return returnValue;
            }
            for (Object o : returnValueList) {
                String value;
                Object valueByGetMethod;
                for (Map.Entry entry : internationalFieldMap.entrySet()) {
                    valueByGetMethod = ReflectUtils.getValueByGetMethod((String)entry.getKey(), o);
                    if (!(valueByGetMethod instanceof String)) continue;
                    value = valueByGetMethod.toString();
                    String[] splitValue = value.split((String)entry.getValue());
                    ClientLanguage clientLanguage = AppContext.getClientLanguage();
                    if (clientLanguage == null) continue;
                    int languageIndex = clientLanguage.getIndex();
                    if (languageIndex < splitValue.length) {
                        ReflectUtils.setValueBySetMethod((String)entry.getKey(), o, (Object)splitValue[languageIndex]);
                        continue;
                    }
                    ReflectUtils.setValueBySetMethod((String)entry.getKey(), o, (Object)"");
                }
                for (Map.Entry entry : desensitizedFieldMap.entrySet()) {
                    valueByGetMethod = ReflectUtils.getValueByGetMethod((String)entry.getKey(), o);
                    if (!(valueByGetMethod instanceof String)) continue;
                    value = valueByGetMethod.toString();
                    switch ((SensitizedType)entry.getValue()) {
                        case mobilePhone: {
                            ReflectUtils.setValueBySetMethod((String)entry.getKey(), o, (Object)DesensitizedUtil.mobilePhone(value));
                            break;
                        }
                        case email: {
                            ReflectUtils.setValueBySetMethod((String)entry.getKey(), o, (Object)DesensitizedUtil.email(value));
                            break;
                        }
                        case chineseName: {
                            ReflectUtils.setValueBySetMethod((String)entry.getKey(), o, (Object)DesensitizedUtil.chineseName(value));
                            break;
                        }
                        case idCardNum: {
                            ReflectUtils.setValueBySetMethod((String)entry.getKey(), o, (Object)DesensitizedUtil.idCardNum(value, 6, 4));
                        }
                    }
                }
            }
        }
        return returnValue;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

