/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.exception.ConcurrentException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ConcurrentHelper {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentHelper.class);
    private static final ConcurrentHashMap<String, Long> cache = new ConcurrentHashMap();
    private static final String LOCK_KEY_PREFIX = "LOCAL_LOCK:";
    private static final long DEFAULT_TIME_OUT = 60000L;

    private static synchronized Long lock(String lockKey) {
        return ConcurrentHelper.lock(lockKey, 60000L);
    }

    private static synchronized Long lock(String lockKey, long milliSecond) {
        Assert.notNull((Object)lockKey, (String)"lockKey \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        long now = System.currentTimeMillis();
        Long value = cache.get(LOCK_KEY_PREFIX + lockKey);
        Long lockId = now + milliSecond;
        if (value == null) {
            cache.put(LOCK_KEY_PREFIX + lockKey, lockId);
            return lockId;
        }
        if (value > now) {
            return null;
        }
        cache.put(LOCK_KEY_PREFIX + lockKey, lockId);
        return lockId;
    }

    private static synchronized boolean unLock(String lockKey, Long lockId) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            return false;
        }
        if (lockId == null) {
            return false;
        }
        Long currentLockId = cache.get(LOCK_KEY_PREFIX + lockKey);
        if (currentLockId != null && currentLockId.equals(lockId)) {
            cache.remove(LOCK_KEY_PREFIX + lockKey);
            return true;
        }
        return false;
    }

    public static void doWork(String key, Task task) {
        ConcurrentHelper.doWork(key, 60000L, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWork(String key, Long time, Task task) {
        Long lock = null;
        try {
            lock = ConcurrentHelper.lock(key, time);
            if (lock == null) {
                log.warn("Key:{} \u6b63\u5728\u5904\u7406\u4e2d...", (Object)key);
                throw new ConcurrentException("\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
            }
            task.run();
        }
        finally {
            ConcurrentHelper.unLock(key, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doCallWork(String key, CallTask<T> callTask) {
        Long lock = null;
        try {
            lock = ConcurrentHelper.lock(key);
            if (lock == null) {
                log.warn("Key:{} \u6b63\u5728\u5904\u7406\u4e2d...", (Object)key);
                throw new ConcurrentException("\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
            }
            T t = callTask.run();
            return t;
        }
        finally {
            ConcurrentHelper.unLock(key, lock);
        }
    }

    public static <T> T doWaitLoop(int waitTime, CallTask<T> callTask) {
        long current = System.currentTimeMillis();
        long end = System.currentTimeMillis() + (long)waitTime * 1000L;
        while (current < end) {
            log.warn("\u5faa\u73af\u4efb\u52a1\u4e2d... time {} -> {}", (Object)current, (Object)end);
            T run = callTask.run();
            if (run != null) {
                log.warn("\u5faa\u73af\u4efb\u52a1\u83b7\u53d6\u503c\u7ed3\u675f... time {} -> {}", (Object)current, (Object)end);
                return run;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            current = System.currentTimeMillis();
        }
        log.warn("\u5faa\u73af\u4efb\u52a1\u672a\u83b7\u53d6\u503c\u7ed3\u675f... time {} -> {}", (Object)current, (Object)end);
        return null;
    }

    public static interface CallTask<T> {
        public T run() throws RuntimeException;
    }

    public static interface Task {
        public void run() throws RuntimeException;
    }
}

