/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.model.LatLng;

public class GpsUtil {
    private static final double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static int getDistanceInt(double lat1, double lng1, double lat2, double lng2) {
        LatLng from = new LatLng(lat1, lng1);
        LatLng to = new LatLng(lat2, lng2);
        double distance = GpsUtil.getDistance(from, to);
        return new Double(distance).intValue();
    }

    public static int getDistanceInt(LatLng from, LatLng to) {
        double distance = GpsUtil.getDistance(from, to);
        return new Double(distance).intValue();
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        LatLng from = new LatLng(lat1, lng1);
        LatLng to = new LatLng(lat2, lng2);
        return GpsUtil.getDistance(from, to);
    }

    public static double getDistance(LatLng from, LatLng to) {
        double radLat1 = GpsUtil.rad(from.getLat());
        double radLat2 = GpsUtil.rad(to.getLat());
        double a = radLat1 - radLat2;
        double b = GpsUtil.rad(from.getLng()) - GpsUtil.rad(to.getLng());
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378.137;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s *= 1000.0;
    }

    public static void main(String[] args) {
        double distance = GpsUtil.getDistance(39.923423, 116.368904, 39.922501, 116.387271);
        int distanceInt = GpsUtil.getDistanceInt(39.923423, 116.368904, 39.922501, 116.387271);
        System.out.println(distance);
        System.out.println(distanceInt);
        int distanceInt1 = GpsUtil.getDistanceInt(new LatLng(39.923423, 116.368904), new LatLng(39.922501, 116.387271));
        System.out.println(distanceInt1);
    }
}

