/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectUtils {
    public static Field recursiveFieldFinder(Class<?> annotatedClass, Class<? extends Annotation> annotationClass) {
        for (Field f : annotatedClass.getDeclaredFields()) {
            if (!f.isAnnotationPresent(annotationClass)) continue;
            return f;
        }
        if (annotatedClass.getSuperclass() != null) {
            return ReflectUtils.recursiveFieldFinder(annotatedClass.getSuperclass(), annotationClass);
        }
        return null;
    }

    public static Field getField(String fieldName, Class<?> clazz) {
        Class<?> old = clazz;
        Field field = null;
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
                if (field != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (field == null) {
            throw new NullPointerException(old + "\u6ca1\u6709" + fieldName + "\u5c5e\u6027");
        }
        return field;
    }

    public static Field getField(String fieldName, String className) {
        try {
            return ReflectUtils.getField(fieldName, Class.forName(className));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(String fieldName, Object object) {
        return ReflectUtils.getField(fieldName, object.getClass());
    }

    public static List<Field> getFields(Class<?> clazz, Class<?> stopClass) {
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            while (clazz != null && clazz != stopClass) {
                fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
                clazz = clazz.getSuperclass();
            }
            return fieldList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static List<Field> getFields(Class<?> clazz) {
        return ReflectUtils.getFields(clazz, Object.class);
    }

    private static List<Class<?>> getSuperClasses(Class<?> clazz, Class<?> stopClass) {
        ArrayList classes = new ArrayList();
        while (clazz != null && clazz != stopClass) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return classes;
    }

    public static void setFieldValue(String fieldName, Object object, Object value) {
        Field field = ReflectUtils.getField(fieldName, object.getClass());
        ReflectUtils.setFieldValue(field, object, value);
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
                field.set(object, value);
                field.setAccessible(false);
            } else {
                field.set(object, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectUtils.getField(fieldName, object.getClass());
        return ReflectUtils.getFieldValue(object, field);
    }

    public static Object getFieldValue(Object object, Field field) {
        try {
            Object value;
            if (!field.isAccessible()) {
                field.setAccessible(true);
                value = field.get(object);
                field.setAccessible(false);
            } else {
                value = field.get(object);
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void setValueBySetMethod(String fieldName, Object object, Object value) {
        if (object == null) {
            throw new RuntimeException("\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value == null) {
            return;
        }
        try {
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method setMethod = ReflectUtils.getMethod(setMethodName, object.getClass(), value.getClass());
            setMethod.invoke(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void setValueBySetMethod(Field field, Object object, Object value) {
        if (object == null) {
            throw new RuntimeException("\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value == null) {
            return;
        }
        ReflectUtils.setValueBySetMethod(field.getName(), object, value);
    }

    public static <T> T getValueByGetMethod(String fieldName, Object object) {
        try {
            if (fieldName != null && fieldName.trim().length() > 0) {
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method getMethod = ReflectUtils.getMethod(getMethodName, object.getClass());
                return (T)getMethod.invoke(object, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getValueByGetMethod(Field field, Object object) {
        return ReflectUtils.getValueByGetMethod(field.getName(), object);
    }

    public static Method getMethod(String methodName, Class<?> clazz) {
        Method method = null;
        while (clazz != Object.class) {
            try {
                method = clazz.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        if (method == null) {
            throw new NullPointerException("\u6ca1\u6709" + methodName + "\u65b9\u6cd5");
        }
        return method;
    }

    public static String getMethodName(String fieldName) {
        String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return methodName;
    }

    public static Method getMethod(String methodName, Class<?> clazz, Class<?> paramType) {
        Method method = null;
        while (clazz != Object.class) {
            try {
                method = clazz.getDeclaredMethod(methodName, paramType);
                if (method != null) {
                    return method;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (method == null) {
            throw new NullPointerException(clazz + "\u6ca1\u6709" + methodName + "\u65b9\u6cd5");
        }
        return method;
    }

    public static Method getMethod(String methodName, Object obj) {
        return ReflectUtils.getMethod(methodName, obj.getClass());
    }

    public static Method getMethod(String methodName, Object obj, Class<?> paramType) {
        return ReflectUtils.getMethod(methodName, obj.getClass(), paramType);
    }

    public static Method getMethod(String methodName, String clazz) {
        try {
            return ReflectUtils.getMethod(methodName, Class.forName(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Method getMethod(String methodName, String clazz, Class<?> paramType) {
        try {
            return ReflectUtils.getMethod(methodName, Class.forName(clazz), paramType);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Annotation getMethodAnnotation(Method method, Class targetAnnotationClass) {
        Object methodAnnotation = method.getAnnotation(targetAnnotationClass);
        return methodAnnotation;
    }

    public static Annotation getFieldAnnotation(Field field, Class targetAnnotationClass) {
        Object methodAnnotation = field.getAnnotation(targetAnnotationClass);
        return methodAnnotation;
    }

    public static Annotation getClassAnnotation(Class targetAnnotationClass, Class<?> targetObjcetClass) {
        Object methodAnnotation = targetObjcetClass.getAnnotation(targetAnnotationClass);
        return methodAnnotation;
    }

    public static Annotation getClassAnnotation(Class targetAnnotationClass, Object obj) {
        return ReflectUtils.getClassAnnotation(targetAnnotationClass, obj.getClass());
    }

    public static Annotation getClassAnnotation(Class targetAnnotationClass, String clazz) {
        try {
            return ReflectUtils.getClassAnnotation(targetAnnotationClass, Class.forName(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getAnnotationValue(String methodName, Annotation annotation) {
        try {
            Method method = annotation.annotationType().getMethod(methodName, new Class[0]);
            Object object = method.invoke((Object)annotation, new Object[0]);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getMethodAnnotationValue(String methodName, Class targetAnnotationClass, String targetObjecMethodName, Class targetObjectClass) {
        Method method = ReflectUtils.getMethod(targetObjecMethodName, targetObjectClass);
        Annotation annotation = ReflectUtils.getMethodAnnotation(method, targetAnnotationClass);
        return ReflectUtils.getAnnotationValue(methodName, annotation);
    }

    public static <T> T getFieldAnnotationValue(String methodName, Class targetAnnotationClass, String targetObjecFieldName, Class targetObjectClass) {
        Field field = ReflectUtils.getField(targetObjecFieldName, targetObjectClass);
        Annotation annotation = ReflectUtils.getFieldAnnotation(field, targetAnnotationClass);
        return ReflectUtils.getAnnotationValue(methodName, annotation);
    }

    public static boolean isSubClassOrEquesClass(Class<?> clazz, Class<?> target) {
        if (clazz == target) {
            return true;
        }
        while (clazz != Object.class) {
            if (clazz == target) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index < params.length && index >= 0) {
            if (!(params[index] instanceof Class)) {
                return Object.class;
            }
            return (Class)params[index];
        }
        return Object.class;
    }
}

