/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;

public class UnitConversionUtil {
    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public static String convertReadableTime(long duration, TimeUnit unit) {
        long seconds;
        long minutes;
        long milliseconds = TimeUnit.MILLISECONDS.convert(duration, unit);
        long hours = TimeUnit.HOURS.convert(milliseconds, TimeUnit.MILLISECONDS);
        if (hours > 0L) {
            milliseconds -= hours * 60L * 60L * 1000L;
        }
        if ((minutes = TimeUnit.MINUTES.convert(milliseconds, TimeUnit.MILLISECONDS)) > 0L) {
            milliseconds -= minutes * 60L * 1000L;
        }
        if ((seconds = TimeUnit.SECONDS.convert(milliseconds, TimeUnit.MILLISECONDS)) > 0L) {
            milliseconds -= seconds * 1000L;
        }
        return String.format("|%s:%s:%s.%s|", hours, minutes, seconds, milliseconds);
    }

    public static BigDecimal convertTime(long duration, TimeUnit sourceUnit, TimeUnit targetUnit) {
        long milliseconds = TimeUnit.MILLISECONDS.convert(duration, sourceUnit);
        if (TimeUnit.MILLISECONDS.equals((Object)targetUnit)) {
            return new BigDecimal(milliseconds);
        }
        if (TimeUnit.SECONDS.equals((Object)targetUnit)) {
            return new BigDecimal(milliseconds).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
        }
        if (TimeUnit.MINUTES.equals((Object)targetUnit)) {
            return new BigDecimal(milliseconds).divide(new BigDecimal(60000), 2, RoundingMode.HALF_UP);
        }
        if (TimeUnit.HOURS.equals((Object)targetUnit)) {
            return new BigDecimal(milliseconds).divide(new BigDecimal(3600000), 2, RoundingMode.HALF_UP);
        }
        if (TimeUnit.DAYS.equals((Object)targetUnit)) {
            return new BigDecimal(milliseconds).divide(new BigDecimal(86400000), 2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }
}

