/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.xss;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.springframework.util.StreamUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Whitelist whitelist = XssHttpServletRequestWrapper.createWhitelist();
    private static final Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
    private byte[] requestBody;
    private Charset charSet;

    private static Whitelist createWhitelist() {
        return Whitelist.relaxed().removeProtocols("a", "href", new String[]{"ftp", "http", "https", "mailto"}).removeProtocols("img", "src", new String[]{"http", "https"}).addAttributes("a", new String[]{"href", "title", "target"}).addTags(new String[]{"div", "span", "embed", "object", "param"}).addAttributes(":all", new String[]{"style", "class", "id", "name"}).addAttributes("object", new String[]{"width", "height", "classid", "codebase"}).addAttributes("param", new String[]{"name", "value"}).addAttributes("embed", new String[]{"src", "quality", "width", "height", "allowFullScreen", "allowScriptAccess", "flashvars", "name", "type", "pluginspage"});
    }

    private static String[] filter(String[] values) {
        if (values != null) {
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                if (values[i] == null || "".equals(values[i])) continue;
                values[i] = Jsoup.clean((String)values[i], (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings).trim();
            }
        }
        return values;
    }

    private static String filter(String value) {
        if (value != null) {
            value = Jsoup.clean((String)value, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings).trim();
        }
        return value;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            String requestBodyStr = this.getRequestPostStr(request);
            if (StringUtils.isNotBlank((CharSequence)requestBodyStr)) {
                requestBodyStr = XssHttpServletRequestWrapper.filter(requestBodyStr);
                JSONObject resultJson = JSONObject.parseObject((String)requestBodyStr);
                this.requestBody = resultJson.toString().getBytes(this.charSet);
            } else {
                this.requestBody = new byte[0];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getRequestPostStr(HttpServletRequest request) throws IOException {
        String charSetStr = request.getCharacterEncoding();
        if (charSetStr == null) {
            charSetStr = "UTF-8";
        }
        this.charSet = Charset.forName(charSetStr);
        return StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)this.charSet);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = Jsoup.clean((String)values[i], (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings).trim();
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public ServletInputStream getInputStream() {
        if (this.requestBody == null) {
            this.requestBody = new byte[0];
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.requestBody);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }
}

