/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.advisor;

import cn.acyou.leo.framework.advisor.RedisLock;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisLockSource {
    private final Map<Object, RedisLockMetadata> metadataCache = new ConcurrentHashMap<Object, RedisLockMetadata>(1024);

    public RedisLockMetadata getRedisLockMetadata(Method method, @Nullable Class<?> targetClass) {
        Set anns;
        Object metadataKey = RedisLockSource.getMetadataKey(method, targetClass);
        RedisLockMetadata metadata = this.metadataCache.get(metadataKey);
        if (metadata == null && !CollectionUtils.isEmpty((Collection)(anns = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)method, RedisLock.class)))) {
            for (RedisLock ann : anns) {
                metadata = new RedisLockMetadata(ann.expire(), ann.key(), ann.waitTime());
                this.metadataCache.put(metadataKey, metadata);
            }
        }
        return metadata;
    }

    private static Object getMetadataKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    public static class RedisLockMetadata {
        private int expire;
        private String key;
        private int waitTime;

        public int getExpire() {
            return this.expire;
        }

        public String getKey() {
            return this.key;
        }

        public int getWaitTime() {
            return this.waitTime;
        }

        public void setExpire(int expire) {
            this.expire = expire;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setWaitTime(int waitTime) {
            this.waitTime = waitTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RedisLockMetadata)) {
                return false;
            }
            RedisLockMetadata other = (RedisLockMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpire() != other.getExpire()) {
                return false;
            }
            if (this.getWaitTime() != other.getWaitTime()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RedisLockMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpire();
            result = result * 59 + this.getWaitTime();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        public String toString() {
            return "RedisLockSource.RedisLockMetadata(expire=" + this.getExpire() + ", key=" + this.getKey() + ", waitTime=" + this.getWaitTime() + ")";
        }

        public RedisLockMetadata(int expire, String key, int waitTime) {
            this.expire = expire;
            this.key = key;
            this.waitTime = waitTime;
        }
    }
}

