/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader.ext;

import cn.acyou.leo.framework.downloader.ext.AbstractDownloadProgressMonitorResponseExtractor;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.client.ClientHttpResponse;

public class ByteArrayResponseExtractor
extends AbstractDownloadProgressMonitorResponseExtractor<byte[]> {
    private long byteCount;

    public ByteArrayResponseExtractor() {
    }

    public ByteArrayResponseExtractor(DownloadProgressPrinter downloadProgressPrinter) {
        super(downloadProgressPrinter);
    }

    @Override
    protected byte[] doExtractData(ClientHttpResponse response) throws IOException {
        int bytesRead;
        long contentLength = response.getHeaders().getContentLength();
        ByteArrayOutputStream out = new ByteArrayOutputStream(contentLength >= 0L ? (int)contentLength : 4096);
        InputStream in = response.getBody();
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            this.byteCount += (long)bytesRead;
        }
        out.flush();
        return out.toByteArray();
    }

    @Override
    public long getAlreadyDownloadLength() {
        return this.byteCount;
    }
}

