/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CacheUtil {
    private static final ConcurrentHashMap<String, CacheBean> CACHE_MAP = new ConcurrentHashMap();
    private static final long DEFAULT_CACHE_DURATION = 7200L;

    public static synchronized <T> T get(String key) {
        CacheBean cacheBean = CACHE_MAP.get(key);
        if (cacheBean != null) {
            if (cacheBean.getExpiresTime() == null) {
                return (T)cacheBean.getCacheValue();
            }
            if (cacheBean.getExpiresTime() > System.currentTimeMillis()) {
                return (T)cacheBean.getCacheValue();
            }
            CACHE_MAP.remove(key);
        }
        return null;
    }

    public static void put(String key, String value) {
        CacheBean cacheBean = new CacheBean(value, null);
        CACHE_MAP.put(key, cacheBean);
    }

    public static void put(String key, Object value, Long duration, TimeUnit timeUnit) {
        CacheBean cacheBean = new CacheBean(value);
        if (duration != null && duration > 0L) {
            long toMillis = timeUnit.toMillis(duration);
            cacheBean.setExpiresTime(System.currentTimeMillis() + toMillis);
        }
        CACHE_MAP.put(key, cacheBean);
    }

    public static <T> T getAndCache(String key, Function<String, Object> function) {
        return CacheUtil.getAndCache(key, 7200L, function);
    }

    public static <T> T getAndCache(String key, Long expire, Function<String, Object> function) {
        T v = CacheUtil.get(key);
        if (v != null) {
            return v;
        }
        Object value = function.apply(key);
        CacheUtil.put(key, value, expire, TimeUnit.SECONDS);
        return (T)value;
    }

    public static void clearAllCache() {
        CACHE_MAP.clear();
    }

    public static void clearCache(String key) {
        CACHE_MAP.remove(key);
    }

    public static void clearCache(List<String> keys) {
        keys.forEach(CACHE_MAP::remove);
    }

    public static class CacheBean {
        private Object cacheValue;
        private Long expiresTime;

        public CacheBean(Object cacheValue) {
            this.cacheValue = cacheValue;
            this.expiresTime = null;
        }

        public CacheBean(Object cacheValue, Long expiresTime) {
            this.cacheValue = cacheValue;
            this.expiresTime = expiresTime;
        }

        public Object getCacheValue() {
            return this.cacheValue;
        }

        public Long getExpiresTime() {
            return this.expiresTime;
        }

        public void setCacheValue(Object cacheValue) {
            this.cacheValue = cacheValue;
        }

        public void setExpiresTime(Long expiresTime) {
            this.expiresTime = expiresTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheBean)) {
                return false;
            }
            CacheBean other = (CacheBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$expiresTime = this.getExpiresTime();
            Long other$expiresTime = other.getExpiresTime();
            if (this$expiresTime == null ? other$expiresTime != null : !((Object)this$expiresTime).equals(other$expiresTime)) {
                return false;
            }
            Object this$cacheValue = this.getCacheValue();
            Object other$cacheValue = other.getCacheValue();
            return !(this$cacheValue == null ? other$cacheValue != null : !this$cacheValue.equals(other$cacheValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $expiresTime = this.getExpiresTime();
            result = result * 59 + ($expiresTime == null ? 43 : ((Object)$expiresTime).hashCode());
            Object $cacheValue = this.getCacheValue();
            result = result * 59 + ($cacheValue == null ? 43 : $cacheValue.hashCode());
            return result;
        }

        public String toString() {
            return "CacheUtil.CacheBean(cacheValue=" + this.getCacheValue() + ", expiresTime=" + this.getExpiresTime() + ")";
        }
    }
}

