/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.commons.SnowFlake;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.DateUtil;
import cn.acyou.leo.framework.util.MathUtil;
import cn.acyou.leo.framework.util.ObjectId;
import cn.acyou.leo.framework.util.StringUtils;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import java.text.DecimalFormat;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdUtil {
    private static RedisUtils redisUtils;
    private static SnowFlake snowFlake;

    private IdUtil() {
    }

    @Autowired(required=false)
    public void setRedisUtils(RedisUtils redisUtils) {
        IdUtil.redisUtils = redisUtils;
    }

    @Autowired(required=false)
    public void setSnowFlake(SnowFlake snowFlake) {
        IdUtil.snowFlake = snowFlake;
    }

    private static SnowFlake checkGetSnowFlake() {
        if (snowFlake == null) {
            throw new ServiceException("ID\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6eSnowFlake!");
        }
        return snowFlake;
    }

    private static RedisUtils checkGetRedisUtil() {
        if (redisUtils == null) {
            throw new ServiceException("ID\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6eRedis!");
        }
        return redisUtils;
    }

    public static long nextId() {
        return IdUtil.checkGetSnowFlake().nextId();
    }

    public static String nextIdStr() {
        return IdUtil.checkGetSnowFlake().nextIdStr();
    }

    public static String nextIdPrefix(String prefix) {
        return IdUtil.checkGetSnowFlake().nextIdPrefix(prefix);
    }

    public static String uuidStr() {
        return UUID.randomUUID().toString();
    }

    public static String uuidStrWithoutLine() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String objectId() {
        return ObjectId.next();
    }

    public static String getDatePrefixId(String prefix) {
        return IdUtil.getDatePrefixId(prefix, 5);
    }

    public static String getDatePrefixId(String prefix, int length) {
        String formatDate = DateUtil.getCurrentDateShortFormat();
        String key = "SEQ:" + formatDate;
        Long increment = IdUtil.checkGetRedisUtil().increment(key, 1L, 129600L);
        long maxV = MathUtil.createMaxLong(length);
        if (increment > maxV) {
            throw new ServiceException("ID\u83b7\u53d6\u9519\u8bef\uff1a\u8d85\u51fa\u6700\u5927\u503c!");
        }
        DecimalFormat df = new DecimalFormat(StringUtils.concatLengthChar(length, '0'));
        return prefix + formatDate + df.format(increment);
    }
}

