/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.util.ArrayList;
import java.util.Collections;

public class NumberUtil {
    public static int UNIT_STEP = 4;
    public static String[] CN_UNITS = new String[]{"\u4e2a", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343", "\u4e07"};
    public static String[] CN_CHARS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};

    public static String getCnNum(int srcNum) {
        StringBuilder descnnum = new StringBuilder();
        if (srcNum <= 0) {
            descnnum = new StringBuilder("\u96f6");
        } else {
            while (srcNum > 0) {
                int singleDigit = srcNum % 10;
                descnnum.insert(0, CN_CHARS[singleDigit]);
                srcNum /= 10;
            }
        }
        return descnnum.toString();
    }

    private static String cvt(String num, boolean isColloquial) {
        String[] integerResult;
        StringBuilder strs = new StringBuilder(32);
        String[] splitNum = num.split("\\.");
        int integer = Integer.parseInt(splitNum[0]);
        int decimal = Integer.parseInt(splitNum[1]);
        for (String str1 : integerResult = NumberUtil.convert(integer, isColloquial)) {
            strs.append(str1);
        }
        if (decimal == 0) {
            return strs.toString();
        }
        String decimalResult = NumberUtil.getCnNum(decimal);
        strs.append("\u70b9");
        strs.append(decimalResult);
        return strs.toString();
    }

    public static String[] convert(long num, boolean isColloquial) {
        if (num < 10L) {
            return new String[]{CN_CHARS[(int)num]};
        }
        char[] chars = String.valueOf(num).toCharArray();
        if (chars.length > CN_UNITS.length) {
            return new String[0];
        }
        boolean isLastUnitStep = false;
        ArrayList<String> cnchars = new ArrayList<String>(chars.length * 2);
        for (int pos = chars.length - 1; pos >= 0; --pos) {
            boolean isUnitStep;
            char ch = chars[pos];
            String cnChar = CN_CHARS[ch - 48];
            int unitPos = chars.length - pos - 1;
            String cnUnit = CN_UNITS[unitPos];
            boolean isZero = ch == '0';
            boolean isZeroLow = pos + 1 < chars.length && chars[pos + 1] == '0';
            boolean bl = isUnitStep = unitPos >= UNIT_STEP && unitPos % UNIT_STEP == 0;
            if (isUnitStep && isLastUnitStep) {
                int size = cnchars.size();
                cnchars.remove(size - 1);
                if (!CN_CHARS[0].equals(cnchars.get(size - 2))) {
                    cnchars.add(CN_CHARS[0]);
                }
            }
            if (isUnitStep || !isZero) {
                cnchars.add(cnUnit);
                isLastUnitStep = isUnitStep;
            }
            if (isZero && (isZeroLow || isUnitStep)) continue;
            cnchars.add(cnChar);
            isLastUnitStep = false;
        }
        Collections.reverse(cnchars);
        int chSize = cnchars.size();
        String chEnd = (String)cnchars.get(chSize - 1);
        if (CN_CHARS[0].equals(chEnd) || CN_UNITS[0].equals(chEnd)) {
            cnchars.remove(chSize - 1);
        }
        if (isColloquial) {
            String chFirst = (String)cnchars.get(0);
            String chSecond = (String)cnchars.get(1);
            if (chFirst.equals(CN_CHARS[1]) && chSecond.startsWith(CN_UNITS[1])) {
                cnchars.remove(0);
            }
        }
        return cnchars.toArray(new String[0]);
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.toUpperCaseAndColloquial(10));
        System.out.println(NumberUtil.toUpperCaseAndColloquial(22));
    }

    private static String toUpperCase(int num) {
        return NumberUtil.cvt(String.valueOf(num), false);
    }

    private static String toUpperCaseAndColloquial(int num) {
        return NumberUtil.cvt(String.valueOf(num), true);
    }
}

