/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.annotation.AccessLimit;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.ElParser;
import cn.acyou.leo.framework.util.Md5Util;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AccessLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitAspect.class);
    private static final String ACCESS_LIMIT_KEY_PREFIX = "ACCESS_LIMIT:";
    @Autowired
    private RedisUtils redisUtils;

    @Pointcut(value="@annotation(accessLimit)")
    public void pointCut(AccessLimit accessLimit) {
    }

    @Around(value="pointCut(accessLimit)")
    public Object around(ProceedingJoinPoint joinPoint, AccessLimit accessLimit) throws Throwable {
        String keyValue = this.getKeyValue(joinPoint, accessLimit.value());
        long accessInterval = accessLimit.interval();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (requestAttributes != null);
        HttpServletRequest request = requestAttributes.getRequest();
        String path = request.getServletPath();
        String token = request.getHeader("Authentication");
        StringBuilder keyBuffer = new StringBuilder(path);
        if (StringUtils.hasText((String)token)) {
            keyBuffer.append(token);
        }
        keyBuffer.append("ARGS:");
        keyBuffer.append(Md5Util.md5(keyValue));
        Boolean aBoolean = this.redisUtils.setIfAbsent(keyBuffer.toString(), "1", accessInterval, TimeUnit.MILLISECONDS);
        if (!aBoolean.booleanValue()) {
            return Result.error((ErrorEnum)CommonErrorEnum.ACCESS_LIMIT);
        }
        return joinPoint.proceed();
    }

    public String getKeyValue(ProceedingJoinPoint joinPoint, String express) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(method);
        return ACCESS_LIMIT_KEY_PREFIX + signature.getDeclaringTypeName() + ":" + methodName + ":" + ElParser.getKey(express, parameterNames, joinPoint.getArgs());
    }
}

