/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.aspect;

import cn.acyou.leo.framework.annotation.authz.Logical;
import cn.acyou.leo.framework.annotation.authz.RequiresPermissions;
import cn.acyou.leo.framework.annotation.authz.RequiresRoles;
import cn.acyou.leo.framework.base.LoginUser;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.exception.ServiceException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class PermissionsAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionsAspect.class);

    @Around(value="@annotation(cn.acyou.leo.framework.annotation.authz.RequiresRoles) || @annotation(cn.acyou.leo.framework.annotation.authz.RequiresPermissions)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean containsAny;
        boolean containsAll;
        Logical logical;
        LoginUser loginUser;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        RequiresRoles requiresRoles = methodSignature.getMethod().getAnnotation(RequiresRoles.class);
        RequiresPermissions requiresPermissions = methodSignature.getMethod().getAnnotation(RequiresPermissions.class);
        if (requiresRoles != null) {
            loginUser = AppContext.getLoginUser();
            if (loginUser == null) {
                throw new ServiceException("\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
            }
            Set<String> roleCodes = loginUser.getRoleCodes();
            logical = requiresRoles.logical();
            Object[] needRoles = requiresRoles.value();
            if (logical.equals((Object)Logical.AND) && !(containsAll = roleCodes.containsAll(Sets.newHashSet((Object[])needRoles)))) {
                throw new ServiceException("\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            if (logical.equals((Object)Logical.OR) && !(containsAny = CollectionUtils.containsAny(roleCodes, (Collection)Sets.newHashSet((Object[])needRoles)))) {
                throw new ServiceException("\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        if (requiresPermissions != null) {
            loginUser = AppContext.getLoginUser();
            if (loginUser == null) {
                throw new ServiceException("\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
            }
            Set<String> permsList = loginUser.getPermsList();
            logical = requiresPermissions.logical();
            Object[] needPermissions = requiresPermissions.value();
            if (logical.equals((Object)Logical.AND) && !(containsAll = permsList.containsAll(Sets.newHashSet((Object[])needPermissions)))) {
                throw new ServiceException("\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            if (logical.equals((Object)Logical.OR) && !(containsAny = CollectionUtils.containsAny(permsList, (Collection)Sets.newHashSet((Object[])needPermissions)))) {
                throw new ServiceException("\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        return joinPoint.proceed();
    }
}

