/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil
extends RegExUtils {
    private static final Pattern REGEX_IP_ADDRESS = Pattern.compile("^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    private static final Pattern REGEX_E_MAIL = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    private static final Pattern REGEX_CHINESE = Pattern.compile("[\u4e00-\u9fa5]");
    private static final Pattern REGEX_NUMBER = Pattern.compile("^-?\\d+$");
    private static final Pattern REGEX_DATE_STR = Pattern.compile("(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)");
    private static final Pattern REGEX_DATE_TIME_STR = Pattern.compile("((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)) (20|21|22|23|[0-1]{1}[0-9]):[0-5]{1}[0-9]:[0-5]{1}[0-9]");
    private static final Pattern REGEX_TIME_STR = Pattern.compile("(0[1-9]|1[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    public static final String REGEX_STRONG_PASSWORD = "^.{6,16}$";
    public static final String REGEX_TELEPHONE = "\\d{3}-\\d{8}|\\d{4}-\\{7,8}";
    public static final String REGEX_MOBILEPHONE = "^1[1-9][0-9]\\d{8}$";
    public static final String REGEX_NUMBER_LETTER_COMBINATION = "^[A-Za-z0-9]+$";
    public static final String REGEX_NUMBER_LETTER_SYMBOL_COMBINATION = "^[A-Za-z0-9,./<>?;':\"\\[\\]{}\\-=!@#$%^&*()_+]+$";
    public static final Pattern NOT_NUMBER = Pattern.compile("[^0-9]");

    public static boolean isIp(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        Matcher matcher = REGEX_IP_ADDRESS.matcher(ip);
        return matcher.find();
    }

    public static boolean isEmail(String email) {
        if (StringUtils.isEmpty((CharSequence)email)) {
            return false;
        }
        Matcher matcher = REGEX_E_MAIL.matcher(email);
        return matcher.find();
    }

    public static boolean isChinese(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        Matcher m = REGEX_CHINESE.matcher(text);
        return m.find();
    }

    public static String extractAll(String text, String regex) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        Matcher matcher = Pattern.compile(regex).matcher(text);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString();
    }

    public static boolean isNumber(String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        Matcher m = REGEX_NUMBER.matcher(number);
        return m.find();
    }

    public static boolean isDecimal(String decimal, int count) {
        if (StringUtils.isEmpty((CharSequence)decimal)) {
            return false;
        }
        String regex = "^(-)?(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){" + count + "})?$";
        return decimal.matches(regex);
    }

    public static boolean isMobilePhone(String phoneNumber) {
        if (StringUtils.isEmpty((CharSequence)phoneNumber)) {
            return false;
        }
        return phoneNumber.matches(REGEX_MOBILEPHONE);
    }

    public static boolean isTelephone(String phoneNumber) {
        if (StringUtils.isEmpty((CharSequence)phoneNumber)) {
            return false;
        }
        return phoneNumber.matches(REGEX_TELEPHONE);
    }

    public static boolean isTelephoneOrMobilephone(String phoneNumber) {
        return RegexUtil.isMobilePhone(phoneNumber) || RegexUtil.isTelephone(phoneNumber);
    }

    public static boolean hasSpecialChar(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        return text.replaceAll("[a-z]*[A-Z]*\\d*-*_*\\s*", "").length() == 0;
    }

    public static boolean isChinese2(String strName) {
        char[] ch;
        for (char c : ch = strName.toCharArray()) {
            if (!RegexUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateStr(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return false;
        }
        Matcher m = REGEX_DATE_STR.matcher(dateStr);
        return m.find();
    }

    public static boolean isNumberLetter(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        return str.matches(REGEX_NUMBER_LETTER_COMBINATION);
    }

    public static boolean isNumberLetterSymbol(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        return str.matches(REGEX_NUMBER_LETTER_SYMBOL_COMBINATION);
    }

    public static boolean isDateTime(String dateTimeStr) {
        if (StringUtils.isEmpty((CharSequence)dateTimeStr)) {
            return false;
        }
        Matcher m = REGEX_DATE_TIME_STR.matcher(dateTimeStr);
        return m.find();
    }

    public static boolean isTime(String timeStr) {
        if (StringUtils.isEmpty((CharSequence)timeStr)) {
            return false;
        }
        Matcher m = REGEX_TIME_STR.matcher(timeStr);
        return m.find();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static int onlyKeepNumbers(String str) {
        String s = NOT_NUMBER.matcher(str).replaceAll("");
        return Integer.parseInt(s);
    }

    public static boolean isStrongPassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return false;
        }
        return password.matches(REGEX_STRONG_PASSWORD);
    }

    public static List<String> getMatchStr(String sourceStr, String regex) {
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(sourceStr);
        ArrayList<String> res = new ArrayList<String>();
        while (matcher.find()) {
            res.add(matcher.group());
        }
        return res;
    }

    public static void main(String[] args) {
        String s = "the request was rejected because its size (57176420) exceeds the configured maximum (52428800)";
        List<String> matchStr = RegexUtil.getMatchStr(s, "\\d+");
        System.out.println(matchStr);
    }
}

