/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.base.ClientType;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.UserAgentUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.StringUtils;

public class SourceUtil {
    public static final String SOURCE_KEY = "source";

    public static ClientType getClientTypeByUserAgent(HttpServletRequest request) {
        if (UserAgentUtil.isWeChat(request)) {
            return ClientType.MINI_PROGRAM;
        }
        if (UserAgentUtil.isAndroid(request)) {
            return ClientType.ANDROID;
        }
        if (UserAgentUtil.isPcWeb(request)) {
            return ClientType.WEB_MANAGER;
        }
        throw new ServiceException("\u4e0d\u652f\u6301\u7684\u8bbe\u5907\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\uff01");
    }

    public static ClientType getClientTypeBySource(HttpServletRequest request) {
        String header = request.getHeader(SOURCE_KEY);
        if (StringUtils.hasText((String)header) && NumberUtils.isParsable((String)header)) {
            int i = Integer.parseInt(header);
            for (ClientType clientType : ClientType.values()) {
                if (i != clientType.getCode()) continue;
                return clientType;
            }
        }
        return ClientType.UNKNOWN;
    }
}

