/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class WorkUtil {
    public static <T> T doCallWork(long timeout, TimeUnit unit, Supplier<T> supplier) {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        do {
            try {
                T t = supplier.get();
                if (t != null) {
                    return t;
                }
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                try {
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } while ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L);
        return null;
    }

    public static void main(String[] args) {
        String res = WorkUtil.doCallWork(5L, TimeUnit.SECONDS, () -> null);
        System.out.println(res);
    }
}

