/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util.redis;

import cn.acyou.leo.framework.exception.ConcurrentException;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.util.redis.ZSetItem;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.query.SortQueryBuilder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static final String LOCK_KEY_PREFIX = "REDIS_LOCK:";
    public static final int DEFAULT_LOCK_TIME_OUT = 60000;
    private static final int DEFAULT_CACHE_SECONDS = 60;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RedisTemplate<Object, Object> redisObjTemplate;
    static final long spinForTimeoutThreshold = 100000000L;

    private RedisUtils() {
        log.info("RedisUtils \u521d\u59cb\u5316\u5b8c\u6210\u3002");
    }

    public ZSetOperations<String, String> opsForZset() {
        return this.redisTemplate.opsForZSet();
    }

    public ValueOperations<String, String> opsForValue() {
        return this.redisTemplate.opsForValue();
    }

    public HashOperations<String, Object, Object> opsForHash() {
        return this.redisTemplate.opsForHash();
    }

    public ListOperations<String, String> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public SetOperations<String, String> opsForSet() {
        return this.redisTemplate.opsForSet();
    }

    public GeoOperations<String, String> opsForGeo() {
        return this.redisTemplate.opsForGeo();
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public Long countExistingKeys(Collection<String> keys) {
        return this.redisTemplate.countExistingKeys(keys);
    }

    public Long delete(Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    public Boolean delete(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean expire(String key, Duration timeout) {
        return this.redisTemplate.expire((Object)key, timeout);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public Boolean expireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long getExpire(String key, TimeUnit unit) {
        return this.redisTemplate.getExpire((Object)key, unit);
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public void rename(String oldKey, String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameIfAbsent(String oldKey, String newKey) {
        return this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public List<String> sort(String key, SortParameters.Order order, long pageNum, long pageSize) {
        long offset = (pageNum - 1L) * pageSize;
        SortQuery sortQuery = SortQueryBuilder.sort((Object)key).order(order).limit(offset, pageSize).build();
        return this.redisTemplate.sort(sortQuery);
    }

    public DataType type(String key) {
        return this.redisTemplate.type((Object)key);
    }

    public Integer append(String key, String value) {
        return this.redisTemplate.opsForValue().append((Object)key, value);
    }

    public Long decrement(String key) {
        return this.redisTemplate.opsForValue().decrement((Object)key);
    }

    public Long decrement(String key, long deal) {
        return this.redisTemplate.opsForValue().decrement((Object)key, deal);
    }

    public Long increment(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key);
    }

    public Long increment(String key, long deal) {
        return this.redisTemplate.opsForValue().increment((Object)key, deal);
    }

    public Long increment(final String key, final long delta, final long timeOut) {
        SessionCallback<Long> sessionCallback = new SessionCallback<Long>(){

            public Long execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                RedisUtils.this.redisTemplate.opsForValue().increment((Object)key, delta);
                List exec = operations.exec();
                Long incValue = (Long)exec.get(0);
                if (incValue != null && incValue == 1L) {
                    RedisUtils.this.redisTemplate.expire((Object)key, timeOut, TimeUnit.SECONDS);
                }
                return incValue;
            }
        };
        return (Long)this.redisTemplate.execute((SessionCallback)sessionCallback);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public String getAndSet(String key, String value) {
        return (String)this.redisTemplate.opsForValue().getAndSet((Object)key, (Object)value);
    }

    public List<String> multiGet(Collection<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    public void multiSet(Map<String, String> keyValues) {
        this.redisTemplate.opsForValue().multiSet(keyValues);
    }

    public Boolean multiSetIfAbsent(Map<String, String> keyValues) {
        return this.redisTemplate.opsForValue().multiSetIfAbsent(keyValues);
    }

    public void set(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void set(String key, String value, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public Boolean setIfAbsent(String key, String value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public Boolean setIfAbsent(String key, String value, long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout, unit);
    }

    public Boolean setIfPresent(String key, String value) {
        return this.redisTemplate.opsForValue().setIfPresent((Object)key, (Object)value);
    }

    public Boolean setIfPresent(String key, String value, long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForValue().setIfPresent((Object)key, (Object)value, timeout, unit);
    }

    public Long size(String key) {
        return this.redisTemplate.opsForValue().size((Object)key);
    }

    public Long hashSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public Long hashDelete(String key, Object ... hashKeys) {
        return this.redisTemplate.opsForHash().delete((Object)key, hashKeys);
    }

    public Boolean hashHasKey(String key, Object hashKeys) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, hashKeys);
    }

    public Object hashGet(String key, Object hashKeys) {
        return this.redisTemplate.opsForHash().get((Object)key, hashKeys);
    }

    public List<Object> hashMultiGet(String key, Collection<Object> hashKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hashKeys);
    }

    public Long hashIncrement(String key, String hashKey, long delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
    }

    public Set<Object> hashKeys(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public void hashPut(String key, String hashKey, String value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, (Object)value);
    }

    public void hashPutIfAbsent(String key, String hashKey, String value) {
        this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)hashKey, (Object)value);
    }

    public void hashPutAll(String key, Map<String, String> entries) {
        this.redisTemplate.opsForHash().putAll((Object)key, entries);
    }

    public List<Object> hashValues(String key) {
        return this.redisTemplate.opsForHash().values((Object)key);
    }

    public Map<Object, Object> hashEntries(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void listSet(String key, long index, String value) {
        this.redisTemplate.opsForList().set((Object)key, index, (Object)value);
    }

    public String listIndex(String key, long index) {
        return (String)this.redisTemplate.opsForList().index((Object)key, index);
    }

    public String listLeftPop(String key) {
        return (String)this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public String listLeftPop(String key, long timeout, TimeUnit unit) {
        return (String)this.redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
    }

    public String listRightPop(String key) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public String listRightPop(String key, long timeout, TimeUnit unit) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
    }

    public Long listIndexOf(String key, String value) {
        return this.redisTemplate.opsForList().indexOf((Object)key, (Object)value);
    }

    public Long listLastIndexOf(String key, String value) {
        return this.redisTemplate.opsForList().lastIndexOf((Object)key, (Object)value);
    }

    public Long listLeftPush(String key, String value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public Long listLeftPush(String key, String pivot, String value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)value);
    }

    public Long listLeftPush(String key, String ... values) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, (Object[])values);
    }

    public Long listLeftPush(String key, Collection<String> values) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, values);
    }

    public Long leftPushIfPresent(String key, String value) {
        return this.redisTemplate.opsForList().leftPushIfPresent((Object)key, (Object)value);
    }

    public Long listRightPush(String key, String value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public Long listRightPush(String key, String pivot, String value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, (Object)value);
    }

    public Long listRightPushAll(String key, String ... values) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, (Object[])values);
    }

    public Long listRightPushAll(String key, Collection<String> values) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    public Long listRightPushIfPresent(String key, String value) {
        return this.redisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)value);
    }

    public List<String> listRange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long listSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public Long listRemove(String key, long count, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, value);
    }

    public Long setAdd(String key, String ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Long setSize(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public Long setRemove(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public Set<String> setMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public Set<String> setDifference(String key, String otherKey) {
        return this.redisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
    }

    public Set<String> setIntersect(String key, String otherKey) {
        return this.redisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
    }

    public Set<String> setUnion(String key, String otherKey) {
        return this.redisTemplate.opsForSet().union((Object)key, (Object)otherKey);
    }

    public Boolean setIsMember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Boolean setMove(String key, String value, String destKey) {
        return this.redisTemplate.opsForSet().move((Object)key, (Object)value, (Object)destKey);
    }

    public String setPop(String key) {
        return (String)this.redisTemplate.opsForSet().pop((Object)key);
    }

    public List<String> setPop(String key, long count) {
        return this.redisTemplate.opsForSet().pop((Object)key, count);
    }

    public Long zSetSize(String key) {
        return this.redisTemplate.opsForZSet().size((Object)key);
    }

    public Boolean zSetAdd(String key, String value, double score) {
        return this.redisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public Long zSetAdd(String key, Collection<ZSetItem> zSetItems) {
        return this.redisTemplate.opsForZSet().add((Object)key, this.buildTypedTuple(zSetItems));
    }

    public Long zSetRemove(String key, Object ... values) {
        return this.redisTemplate.opsForZSet().remove((Object)key, values);
    }

    public Long zSetRemoveRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public Long zSetRemoveRangeByScore(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public Long zSetCount(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public Double zSetIncrementScore(String key, String member, double deal) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, (Object)member, deal);
    }

    public Set<String> zSetRangeByLex(String key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.redisTemplate.opsForZSet().rangeByLex((Object)key, range, limit);
    }

    public Set<String> zSetRangeByScore(String key, double min, double max, long offset, long count) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, min, max, offset, count);
    }

    public Set<String> zSetOrderByScoreAsc(String key, int pageNum, int pageSize) {
        long offset = (long)(pageNum - 1) * (long)pageSize;
        return this.zSetRangeByScore(key, 0.0, Double.MAX_VALUE, offset, pageSize);
    }

    public Set<String> zSetOrderByScoreDesc(String key, int pageNum, int pageSize) {
        long offset = (long)(pageNum - 1) * (long)pageSize;
        return this.zSetReverseRangeByScore(key, 0.0, Double.MAX_VALUE, offset, pageSize);
    }

    public Long zSetRank(String key, Object v) {
        return this.redisTemplate.opsForZSet().rank((Object)key, v);
    }

    public Long zSetReverseRank(String key, Object v) {
        return this.redisTemplate.opsForZSet().reverseRank((Object)key, v);
    }

    public Set<String> zSetReverseRangeLimit(String key, long limit) {
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, 0L, limit);
    }

    public Set<String> zSetReverseRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
    }

    public Set<String> zSetReverseRangeByScore(String key, double min, double max, long offset, long count) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, offset, count);
    }

    public List<ZSetItem> zSetReverseRangeWithScores(String key, long start, long end) {
        Set sset = this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
        if (sset == null) {
            return new ArrayList<ZSetItem>();
        }
        return this.buildZsetList(sset);
    }

    private List<ZSetItem> buildZsetList(Set<ZSetOperations.TypedTuple<String>> zset) {
        ArrayList<ZSetItem> result = new ArrayList<ZSetItem>();
        for (ZSetOperations.TypedTuple<String> stringTypedTuple : zset) {
            ZSetItem item = new ZSetItem();
            String value = (String)stringTypedTuple.getValue();
            Double score = stringTypedTuple.getScore();
            item.setValue(value);
            item.setScore(score);
            result.add(item);
        }
        return result;
    }

    private Set<ZSetOperations.TypedTuple<String>> buildTypedTuple(Collection<ZSetItem> zSetItems) {
        HashSet<ZSetOperations.TypedTuple<String>> result = new HashSet<ZSetOperations.TypedTuple<String>>();
        for (ZSetItem zSetItem : zSetItems) {
            DefaultTypedTuple typedTuple = new DefaultTypedTuple((Object)zSetItem.getValue(), zSetItem.getScore());
            result.add((ZSetOperations.TypedTuple<String>)typedTuple);
        }
        return result;
    }

    public String getAndCache(String key, Function<String, String> function) {
        return this.getAndCacheObj(key, 60L, function);
    }

    public String getAndCache(String key, long timeOut, Function<String, String> function) {
        String v = this.get(key);
        if (v != null && v.length() > 0) {
            return v;
        }
        String value = function.apply(key);
        this.set(key, value, timeOut, TimeUnit.SECONDS);
        return value;
    }

    public <O> O getAndCacheObj(String key, long timeOut, Function<String, O> function) {
        Object o = this.redisObjTemplate.opsForValue().get((Object)key);
        if (o != null) {
            return (O)o;
        }
        O value = function.apply(key);
        this.redisObjTemplate.opsForValue().set((Object)key, value, timeOut, TimeUnit.SECONDS);
        return value;
    }

    public String lock(String lockKey) {
        return this.lock(lockKey, 60000L);
    }

    public String lock(String lockKey, long timeOut) {
        if (!StringUtils.hasText((String)lockKey)) {
            throw new ServiceException("lockKey must not be null .");
        }
        assert (timeOut > 1000L);
        String lockId = UUID.randomUUID().toString();
        Boolean success = this.redisTemplate.opsForValue().setIfAbsent((Object)(LOCK_KEY_PREFIX + lockKey), (Object)lockId, timeOut, TimeUnit.MILLISECONDS);
        if (success != null && success.booleanValue()) {
            return lockId;
        }
        return null;
    }

    public String lockLoop(String lockKey, long waitTimeout, long timeOut) {
        long nanosWaitTimeout = TimeUnit.NANOSECONDS.convert(waitTimeout, TimeUnit.MILLISECONDS);
        long deadline = System.nanoTime() + nanosWaitTimeout;
        if (waitTimeout <= 0L) {
            return this.lock(lockKey, timeOut);
        }
        try {
            do {
                String lockId;
                if ((lockId = this.lock(lockKey, timeOut)) != null) {
                    return lockId;
                }
                if (deadline - System.nanoTime() <= 100000000L) continue;
                Thread.sleep(100L);
            } while (System.nanoTime() < deadline);
        }
        finally {
            return null;
        }
    }

    public void unLock(String lockKey, String lockId) {
        if (!StringUtils.hasText((String)lockKey)) {
            return;
        }
        if (!StringUtils.hasText((String)lockId)) {
            return;
        }
        String currentLockId = (String)this.redisTemplate.opsForValue().get((Object)(LOCK_KEY_PREFIX + lockKey));
        if (currentLockId != null && currentLockId.equals(lockId)) {
            this.redisTemplate.delete((Object)(LOCK_KEY_PREFIX + lockKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(String key, Long time, Task task) {
        String lockId = null;
        try {
            lockId = this.lock(key, time);
            if (lockId == null) {
                log.warn("Key:{} \u6b63\u5728\u5904\u7406\u4e2d...", (Object)key);
                throw new ConcurrentException("\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
            }
            task.run();
        }
        finally {
            this.unLock(key, lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doCallWork(String key, Long time, CallTask<T> callTask) {
        String lockId = null;
        try {
            lockId = this.lock(key, time);
            if (lockId == null) {
                log.warn("Key:{} \u6b63\u5728\u5904\u7406\u4e2d...", (Object)key);
                throw new ConcurrentException("\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
            }
            T t = callTask.run();
            return t;
        }
        finally {
            this.unLock(key, lockId);
        }
    }

    public static interface CallTask<T> {
        public T run() throws RuntimeException;
    }

    public static interface Task {
        public void run() throws RuntimeException;
    }
}

