/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.interceptor;

import cn.acyou.leo.framework.base.ClientLanguage;
import cn.acyou.leo.framework.base.InterfaceCallStatistics;
import cn.acyou.leo.framework.base.LoginUser;
import cn.acyou.leo.framework.commons.AsyncManager;
import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.constant.Constant;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.prop.LeoProperty;
import cn.acyou.leo.framework.service.UserTokenService;
import cn.acyou.leo.framework.util.CacheUtil;
import cn.acyou.leo.framework.util.IPUtil;
import cn.acyou.leo.framework.util.SourceUtil;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public abstract class BaseInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BaseInterceptor.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private LeoProperty leoProperty;
    @Autowired(required=false)
    private UserTokenService userTokenService;
    AntPathMatcher pathMatcher = new AntPathMatcher();

    protected abstract String getToken(HttpServletRequest var1);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        AppContext.setRequestTimeStamp(System.currentTimeMillis());
        String requestURI = request.getRequestURI();
        String requestMethod = request.getMethod();
        String remoteIp = IPUtil.getClientIp(request);
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null && parameterMap.size() > 0) {
            ArrayList<String> params = new ArrayList<String>();
            for (Map.Entry stringEntry : parameterMap.entrySet()) {
                params.add((String)stringEntry.getKey() + "=" + ((String[])stringEntry.getValue())[0]);
            }
            String joinParam = StringUtils.collectionToDelimitedString(params, (String)"&");
            requestURI = requestURI + "?" + joinParam;
        }
        String logMessage = String.format("\u8bbf\u95ee\u5f00\u59cb \u2014\u2014> %s [%s %s] ", remoteIp, requestMethod, requestURI);
        String requestBody = "";
        if (this.leoProperty.isPrintRequestBody()) {
            if (request.getContentType() != null && request.getContentType().contains("application/json")) {
                String inputStr;
                ServletInputStream is = request.getInputStream();
                StringBuilder responseStrBuilder = new StringBuilder();
                BufferedReader streamReader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                while ((inputStr = streamReader.readLine()) != null) {
                    responseStrBuilder.append(inputStr);
                }
                requestBody = responseStrBuilder.toString();
            }
            if (requestBody.length() > 0) {
                AppContext.setRequestBody(requestBody);
                logMessage = logMessage + String.format(" \u8bf7\u6c42\u4f53: %s", requestBody);
            }
        }
        log.info(logMessage);
        if (this.leoProperty.isTokenVerify() && !this.isMatcherPath(request.getRequestURI())) {
            String token = this.getToken(request);
            if (!StringUtils.hasText((String)token)) {
                this.falseResult(response, CommonErrorEnum.E_UNAUTHENTICATED);
                return false;
            }
            String userId = this.redisUtils.get("USER:LOGIN:TOKEN:" + token);
            if (!StringUtils.hasText((String)userId)) {
                String loginAtOtherWhere = this.redisUtils.get("USER:LOGIN:LOGINATOTHERWHERE:" + token);
                if (StringUtils.hasText((String)loginAtOtherWhere)) {
                    this.falseResult(response, CommonErrorEnum.E_LOGIN_AT_OTHER_WHERE);
                } else {
                    this.falseResult(response, CommonErrorEnum.E_LOGIN_TIMEOUT);
                }
                return false;
            }
            LoginUser loginUser = this.userTokenService.getLoginUserByUserId(Long.valueOf(userId));
            AppContext.setLoginUser(loginUser);
        }
        AppContext.setIp(remoteIp);
        AppContext.setActionUrl(requestURI);
        AppContext.setClientType(SourceUtil.getClientTypeByUserAgent(request));
        String language = request.getHeader("Language");
        AppContext.setClientLanguage(ClientLanguage.getLanguage(language));
        AppContext.MethodInfoBean methodInfoBean = new AppContext.MethodInfoBean();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String methodInfo = handlerMethod.toString();
            methodInfoBean = (AppContext.MethodInfoBean)CacheUtil.getAndCache("BaseInterceptor.methodDebug." + methodInfo, 0L, k -> {
                Method method = handlerMethod.getMethod();
                String apiRemark = "";
                ApiOperation annotation = method.getAnnotation(ApiOperation.class);
                if (annotation != null) {
                    apiRemark = annotation.value();
                    Extension[] extensions = annotation.extensions();
                    if (extensions != null) {
                        for (Extension extension : extensions) {
                            if (extension.properties() == null) continue;
                            for (ExtensionProperty property : extension.properties()) {
                                if (!property.name().equalsIgnoreCase("debug") || !property.value().equalsIgnoreCase("false")) continue;
                                return new AppContext.MethodInfoBean(methodInfo, apiRemark, "false");
                            }
                        }
                    }
                }
                return new AppContext.MethodInfoBean(methodInfo, apiRemark, "true");
            });
        }
        AppContext.setActionApiOperation(new String[]{methodInfoBean.getMethodInfo(), methodInfoBean.getApiRemark(), methodInfoBean.getDebug()});
        return true;
    }

    private boolean isMatcherPath(String path) {
        List<String> ignoreUriList = this.leoProperty.getIgnoreUriList();
        for (String url : ignoreUriList) {
            if (!this.pathMatcher.match(url, path)) continue;
            return true;
        }
        return false;
    }

    private void falseResult(HttpServletResponse response, CommonErrorEnum commonErrorEnum) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        Result resultBody = Result.error((ErrorEnum)commonErrorEnum);
        ObjectMapper objectMapper = new ObjectMapper();
        response.getWriter().println(objectMapper.writeValueAsString((Object)resultBody));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ContentCachingResponseWrapper resp;
        String contentType;
        this.processInterfaceStatistics(request);
        Long requestTimeStamp = AppContext.getRequestTimeStamp();
        String logMessage = String.format("\u8bbf\u95ee\u7ed3\u675f <\u2014\u2014  [status:%s \u8017\u65f6:%s ms]", response.getStatus(), requestTimeStamp != null ? Long.valueOf(System.currentTimeMillis() - AppContext.getRequestTimeStamp()) : "-");
        if (this.leoProperty.isPrintResponseBody() && (contentType = response.getContentType()) != null && contentType.contains("application/json") && (resp = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class)) != null) {
            String responseBody = StreamUtils.copyToString((InputStream)resp.getContentInputStream(), (Charset)StandardCharsets.UTF_8);
            logMessage = logMessage + String.format(" \u54cd\u5e94\u4f53: %s", responseBody.length() > 1000 ? responseBody.substring(0, 1000) : responseBody);
        }
        log.info(logMessage);
        AppContext.clearThreadLocal();
        PageHelper.clearPage();
    }

    public void processInterfaceStatistics(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (!this.leoProperty.isInterfaceCallStatistics()) {
            return;
        }
        if (this.leoProperty.getIgnoreUriList().contains(requestURI)) {
            return;
        }
        if (!AppContext.getActionDebug()) {
            return;
        }
        Result<?> exceptionResult = AppContext.getExceptionResult();
        InterfaceCallStatistics interfaceCallStatistics = InterfaceCallStatistics.builder().url(requestURI).type(Constant.CONS_1).methodType(request.getMethod()).methodInfo(AppContext.getActionApiMethodInfoRemark()).methodDesc(AppContext.getActionApiOperationValue()).params(AppContext.getRequestBody()).startTime(new Date(AppContext.getRequestTimeStamp())).execTime(System.currentTimeMillis() - AppContext.getRequestTimeStamp()).errorMessage(exceptionResult != null ? exceptionResult.getMessage() : null).errorStackTrace(exceptionResult != null && exceptionResult.getData() != null ? JSON.toJSONString((Object)exceptionResult.getData()) : null).clientType(AppContext.getClientType().getMessage()).ip(AppContext.getIp()).userId(AppContext.getLoginUser() != null ? AppContext.getLoginUser().getUserId() : null).userName(AppContext.getLoginUser() != null ? AppContext.getLoginUser().getUserName() : null).build();
        AsyncManager.execute(() -> log.info(">>> {}", (Object)interfaceCallStatistics));
    }
}

