/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.exception.ServiceException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class BeanCopyUtil {
    public static <T, E> E copy(T t, Class<E> clz) {
        if (t == null) {
            return null;
        }
        try {
            E e = clz.newInstance();
            BeanUtils.copyProperties(t, e);
            return e;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new ServiceException("BeanCopy\u51fa\u9519\u4e86\uff01{}->{}", t, clz.getName());
        }
    }

    public static <T, E> List<E> copyList(Collection<T> l, Class<E> clz) {
        ArrayList list = new ArrayList();
        if (!CollectionUtils.isEmpty(l)) {
            l.forEach(item -> list.add(BeanCopyUtil.copy(item, clz)));
        }
        return list;
    }

    public static <E> E copyByJson(Object o, Class<E> clz) {
        String json = JSON.toJSONString((Object)o);
        return (E)JSON.parseObject((String)json, clz);
    }

    public static <E> E copyByJson(Object o, TypeReference<E> typeReference) {
        String json = JSON.toJSONString((Object)o);
        return (E)JSON.parseObject((String)json, typeReference, (Feature[])new Feature[0]);
    }

    public static <M> void merge(M target, M destination) {
        BeanCopyUtil.merge(target, destination, false);
    }

    public static <M> void merge(M target, M destination, boolean nullCoverTarget) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass());
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                Object defaultValue;
                if (descriptor.getWriteMethod() == null || (defaultValue = descriptor.getReadMethod().invoke(destination, new Object[0])) == null && !nullCoverTarget) continue;
                descriptor.getWriteMethod().invoke(target, defaultValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

