/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.IOUtil;
import cn.acyou.leo.framework.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.FileSystemUtils;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    public static final String SEPARATOR = File.separator;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String USER_HOME_DIR = System.getProperty("user.home");
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final Map<String, String> FILE_TYPE_MAP = new ConcurrentSkipListMap<String, String>((s1, s2) -> {
        int len2;
        int len1 = s1.length();
        if (len1 == (len2 = s2.length())) {
            return s1.compareTo((String)s2);
        }
        return len2 - len1;
    });
    public static final String UNKNOWN = "UNKNOWN";
    private static final List<String> imageTypes;

    public static File getTmpDir() {
        return new File(TEMP_DIR);
    }

    public static File getUserHomeDir() {
        return new File(USER_HOME_DIR);
    }

    public static File createTempDir(String subDir) {
        File dirFile = new File(TEMP_DIR, subDir);
        if (!dirFile.exists()) {
            log.info("\u521b\u5efa\u4e34\u65f6\u76ee\u5f55\uff1a{} {}", (Object)dirFile.getAbsolutePath(), (Object)(dirFile.mkdirs() ? "\u6210\u529f" : "\u5931\u8d25"));
        }
        return dirFile;
    }

    public static File createTempDirWithPrefix(String prefix) throws Exception {
        Path tempDirectory = Files.createTempDirectory(prefix, new FileAttribute[0]);
        return tempDirectory.toFile();
    }

    public static boolean deleteRecursively(File file) {
        return FileSystemUtils.deleteRecursively((File)file);
    }

    public static void copyRecursively(File src, File dest) throws Exception {
        FileSystemUtils.copyRecursively((File)src, (File)dest);
    }

    public static int copy(InputStream in, OutputStream out) throws Exception {
        return FileCopyUtils.copy((InputStream)in, (OutputStream)out);
    }

    public static File createTempFile(String prefix, String extendName) throws IOException {
        return Files.createTempFile(prefix, extendName, new FileAttribute[0]).toFile();
    }

    public static File createTempFile(String subDir, String prefix, String extendName) throws IOException {
        File tempDir = FileUtil.createTempDir(subDir);
        return Files.createTempFile(tempDir.toPath(), prefix, extendName, new FileAttribute[0]).toFile();
    }

    public static File createTempFileFullName(String fullName) {
        return new File(FileUtil.getTmpDir(), fullName);
    }

    public static File createTempFileFullName(String subDir, String fullName) {
        return new File(FileUtil.createTempDir(subDir), fullName);
    }

    public static boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static boolean notExists(String path) {
        return Files.notExists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static Path copy(String source, String target) throws Exception {
        return Files.copy(Paths.get(source, new String[0]), Paths.get(target, new String[0]), new CopyOption[0]);
    }

    private static String getType(String fileStreamHexHead) {
        for (Map.Entry<String, String> fileTypeEntry : FILE_TYPE_MAP.entrySet()) {
            if (!fileStreamHexHead.toLowerCase().startsWith(fileTypeEntry.getKey().toLowerCase())) continue;
            return fileTypeEntry.getValue();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTypeByStream(File file) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = FileUtil.getTypeByStream(in);
        }
        catch (Exception exception) {
            IOUtil.close(in);
            return UNKNOWN;
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(in);
        return string;
    }

    public static String getTypeByStream(String path) {
        return FileUtil.getTypeByStream(new File(path));
    }

    public static String getTypeByStream(InputStream in) {
        try {
            return FileUtil.getType(IOUtil.readHex28Upper(in));
        }
        catch (IOException e) {
            e.printStackTrace();
            return UNKNOWN;
        }
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtil.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return fileName.substring(index + 1);
    }

    public static boolean isImage(String extName) {
        if (StringUtils.isBlank(extName)) {
            return false;
        }
        return imageTypes.contains(extName.toLowerCase());
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:\\ToUpload\\G.E.M.\u9093\u7d2b\u68cb - A.I.N.Y..mp3");
        System.out.println(FileUtil.createTempFile("", "33"));
        System.out.println(File.createTempFile("", "33"));
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        FileUtil.failIfNullBytePresent(filename);
        int index = FileUtil.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String getBaseName(String filename) {
        return FileUtil.removeExtension(FileUtil.getName(filename));
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileUtil.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String getFullPath(String filename) {
        return FileUtil.doGetFullPath(filename, true);
    }

    public static String getFullPathNoEndSeparator(String filename) {
        return FileUtil.doGetFullPath(filename, false);
    }

    private static String doGetFullPath(String filename, boolean includeSeparator) {
        if (filename == null) {
            return null;
        }
        int prefix = FileUtil.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= filename.length()) {
            if (includeSeparator) {
                return FileUtil.getPrefix(filename);
            }
            return filename;
        }
        int index = FileUtil.indexOfLastSeparator(filename);
        if (index < 0) {
            return filename.substring(0, prefix);
        }
        int end = index + (includeSeparator ? 1 : 0);
        if (end == 0) {
            ++end;
        }
        return filename.substring(0, end);
    }

    private static String getPrefix(String filename) {
        if (filename == null) {
            return null;
        }
        int len = FileUtil.getPrefixLength(filename);
        if (len < 0) {
            return null;
        }
        if (len > filename.length()) {
            FileUtil.failIfNullBytePresent(filename + '/');
            return filename + '/';
        }
        String path = filename.substring(0, len);
        FileUtil.failIfNullBytePresent(path);
        return path;
    }

    private static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return FileUtil.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !FileUtil.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            if (ch0 == '/') {
                return 1;
            }
            return -1;
        }
        if (FileUtil.isSeparator(ch0) && FileUtil.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return FileUtil.isSeparator(ch0) ? 1 : 0;
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    private static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        FileUtil.failIfNullBytePresent(filename);
        int index = FileUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    private static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileUtil.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private static void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }

    static {
        FILE_TYPE_MAP.put("ffd8ff", "jpg");
        FILE_TYPE_MAP.put("89504e47", "png");
        FILE_TYPE_MAP.put("4749463837", "gif");
        FILE_TYPE_MAP.put("4749463839", "gif");
        FILE_TYPE_MAP.put("49492a00227105008037", "tif");
        FILE_TYPE_MAP.put("424d228c010000000000", "bmp");
        FILE_TYPE_MAP.put("424d8240090000000000", "bmp");
        FILE_TYPE_MAP.put("424d8e1b030000000000", "bmp");
        FILE_TYPE_MAP.put("41433130313500000000", "dwg");
        FILE_TYPE_MAP.put("7b5c727466315c616e73", "rtf");
        FILE_TYPE_MAP.put("38425053000100000000", "psd");
        FILE_TYPE_MAP.put("46726f6d3a203d3f6762", "eml");
        FILE_TYPE_MAP.put("5374616E64617264204A", "mdb");
        FILE_TYPE_MAP.put("252150532D41646F6265", "ps");
        FILE_TYPE_MAP.put("255044462d312e", "pdf");
        FILE_TYPE_MAP.put("2e524d46000000120001", "rmvb");
        FILE_TYPE_MAP.put("464c5601050000000900", "flv");
        FILE_TYPE_MAP.put("0000001C66747970", "mp4");
        FILE_TYPE_MAP.put("00000020667479706", "mp4");
        FILE_TYPE_MAP.put("00000018667479706D70", "mp4");
        FILE_TYPE_MAP.put("49443303000000002176", "mp3");
        FILE_TYPE_MAP.put("000001ba210001000180", "mpg");
        FILE_TYPE_MAP.put("3026b2758e66cf11a6d9", "wmv");
        FILE_TYPE_MAP.put("52494646e27807005741", "wav");
        FILE_TYPE_MAP.put("52494646d07d60074156", "avi");
        FILE_TYPE_MAP.put("4d546864000000060001", "mid");
        FILE_TYPE_MAP.put("526172211a0700cf9073", "rar");
        FILE_TYPE_MAP.put("235468697320636f6e66", "ini");
        FILE_TYPE_MAP.put("504B03040a0000000000", "jar");
        FILE_TYPE_MAP.put("504B0304140008000800", "jar");
        FILE_TYPE_MAP.put("d0cf11e0a1b11ae10", "xls");
        FILE_TYPE_MAP.put("504B0304", "zip");
        FILE_TYPE_MAP.put("4d5a9000030000000400", "exe");
        FILE_TYPE_MAP.put("3c25402070616765206c", "jsp");
        FILE_TYPE_MAP.put("4d616e69666573742d56", "mf");
        FILE_TYPE_MAP.put("7061636b616765207765", "java");
        FILE_TYPE_MAP.put("406563686f206f66660d", "bat");
        FILE_TYPE_MAP.put("1f8b0800000000000000", "gz");
        FILE_TYPE_MAP.put("cafebabe0000002e0041", "class");
        FILE_TYPE_MAP.put("49545346030000006000", "chm");
        FILE_TYPE_MAP.put("04000000010000001300", "mxp");
        FILE_TYPE_MAP.put("6431303a637265617465", "torrent");
        FILE_TYPE_MAP.put("6D6F6F76", "mov");
        FILE_TYPE_MAP.put("FF575043", "wpd");
        FILE_TYPE_MAP.put("CFAD12FEC5FD746F", "dbx");
        FILE_TYPE_MAP.put("2142444E", "pst");
        FILE_TYPE_MAP.put("AC9EBD8F", "qdf");
        FILE_TYPE_MAP.put("E3828596", "pwl");
        FILE_TYPE_MAP.put("2E7261FD", "ram");
        imageTypes = Lists.newArrayList((Object[])new String[]{"png", "jpg", "jpeg"});
    }
}

