/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util;

import cn.acyou.leo.framework.util.function.Task;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkUtil.class);

    public static <T> T doCallWork(long timeout, TimeUnit unit, Supplier<T> supplier) {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        do {
            try {
                T t = supplier.get();
                if (t != null) {
                    return t;
                }
            }
            catch (Exception ex) {
                if (rem <= 0L) continue;
                try {
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    e.printStackTrace();
                }
            }
        } while ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L);
        return null;
    }

    public static void tryRun(Task task) {
        try {
            task.run();
        }
        catch (Exception e) {
            WorkUtil.printFirstStack(e);
        }
    }

    public static void printFirstStack(Throwable e) {
        String reason = e.getMessage();
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            StackTraceElement stackTraceElement = stackTrace[0];
            reason = reason + " ERROR MSG: " + stackTraceElement.getClassName() + "|" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
        }
        log.error(reason);
    }

    public static void trySleep5000() {
        WorkUtil.trySleep(5000L);
    }

    public static void trySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

