/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.commons;

import cn.acyou.leo.framework.constant.CommonErrorEnum;
import cn.acyou.leo.framework.context.AppContext;
import cn.acyou.leo.framework.exception.ServiceException;
import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.Result;
import cn.acyou.leo.framework.util.IPUtil;
import cn.acyou.leo.framework.util.IdUtil;
import cn.acyou.leo.framework.util.redis.RedisUtils;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/common"})
@Api(tags={"\u7cfb\u7edf\u516c\u5171\u4f7f\u7528"}, hidden=true)
public class SysCommonController {
    private static final Logger log = LoggerFactory.getLogger(SysCommonController.class);
    @Autowired(required=false)
    private RedisUtils redisUtils;

    @GetMapping(value={"/status"})
    @ApiOperation(value="\u72b6\u6001\u68c0\u67e5")
    @ResponseBody
    public String check() {
        return "ok";
    }

    @GetMapping(value={"/unauthorized"})
    @ApiOperation(value="\u6ca1\u6709\u6743\u9650")
    @ResponseBody
    public Result<Void> unauthorized() {
        return Result.error((ErrorEnum)CommonErrorEnum.E_UNAUTHORIZED);
    }

    @ApiOperation(value="\u6253\u5370\u8bf7\u6c42\u4fe1\u606f")
    @RequestMapping(value={"printRequest"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result<JSONObject> printRequest(HttpServletRequest request, @RequestBody(required=false) Object requestBody, @RequestHeader Map<String, Object> requestHeader) {
        Map requestParameter = request.getParameterMap();
        JSONObject response = new JSONObject();
        response.put("requestParameter", (Object)requestParameter);
        response.put("requestBody", requestBody);
        response.put("requestHeader", requestHeader);
        return Result.success((Object)response);
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5668\u5916\u7f51IP")
    @GetMapping(value={"ip"})
    @ResponseBody
    public Result<JSONObject> ip() {
        String s = HttpUtil.get((String)"http://httpbin.org/ip");
        log.info("\u670d\u52a1\u5668\u5916\u7f51IP\uff1a{}", (Object)s);
        JSONObject jsonObject = JSON.parseObject((String)s);
        jsonObject.put("local", (Object)IPUtil.getLocalIP());
        jsonObject.put("client", (Object)AppContext.getIp());
        return Result.success((Object)jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/idempotent"})
    @ApiOperation(value="\u83b7\u53d6\u5e42\u7b49\u5e8f\u5217 prefix\u524d\u7f00\uff08\u5fc5\u4f20\uff09\u3002sequence\uff1a\u7a7a\u65f6\u751f\u6210\uff0c\u975e\u7a7a\u65f6\u5224\u65ad\u3002operate\uff1a\u6821\u9a8c\u5e76\u5220\u9664")
    @ResponseBody
    public Result<String> idempotent(@RequestParam(value="prefix") String prefix, String sequence, String operate) {
        if (sequence == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sequence)) {
            String uuid = IdUtil.uuidStrWithoutLine();
            this.redisUtils.set("LEO:AUTO_IDEMPOTENT_SEQUENCE:" + prefix + uuid, "1", 1L, TimeUnit.HOURS);
            return Result.success((Object)uuid);
        }
        String key = "LEO:AUTO_IDEMPOTENT_SEQUENCE:" + prefix + sequence;
        String v = null;
        try {
            v = this.redisUtils.get(key);
            if (!StringUtils.hasText((String)v)) {
                throw new ServiceException(CommonErrorEnum.REPETITIVE_OPERATION);
            }
            Result result = Result.success((Object)sequence);
            return result;
        }
        finally {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)operate) && "delete".equalsIgnoreCase(operate)) {
                this.redisUtils.delete(key);
            }
        }
    }

    @GetMapping(value={"/error"})
    @ApiOperation(value="MV\u9519\u8bef\u9875\u9762")
    @ResponseBody
    public Result<?> error(HttpServletRequest request) {
        int status = (Integer)request.getAttribute("status");
        String error = (String)request.getAttribute("error");
        String message = (String)request.getAttribute("message");
        Result resultError = Result.error((int)status, (String)(error + "|" + message));
        if (HttpStatus.NOT_FOUND.value() == status) {
            resultError = Result.error((ErrorEnum)CommonErrorEnum.E_NOT_FOUNT);
        }
        return resultError;
    }
}

