/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.config;

import cn.acyou.leo.framework.thread.MdcThreadPoolTaskExecutor;
import cn.acyou.leo.framework.thread.MdcThreadPoolTaskScheduler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class ThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);
    private static final int SCHEDULE_CORE_POOL_SIZE = 5;
    private static final String TASK_THREAD_NAME = "Leo-executor-";
    private static final String SCHEDULED_THREAD_NAME = "Leo-scheduled-%d";

    @ConditionalOnMissingBean(name={"threadPoolTaskExecutor"})
    @Bean(name={"threadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor threadPoolExecutor() {
        MdcThreadPoolTaskExecutor executor = new MdcThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(TASK_THREAD_NAME);
        executor.setCorePoolSize(6);
        executor.setMaxPoolSize(50);
        executor.setQueueCapacity(100);
        executor.setKeepAliveSeconds(300);
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setAllowCoreThreadTimeOut(false);
        return executor;
    }

    @ConditionalOnMissingBean(name={"scheduledExecutorService"})
    @Bean(name={"scheduledExecutorService"})
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        MdcThreadPoolTaskScheduler scheduler = new MdcThreadPoolTaskScheduler();
        scheduler.setPoolSize(5);
        scheduler.setThreadFactory((ThreadFactory)new BasicThreadFactory.Builder().namingPattern(SCHEDULED_THREAD_NAME).daemon(true).build());
        return scheduler;
    }
}

