/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.downloader;

import cn.acyou.leo.framework.downloader.Downloader;
import cn.acyou.leo.framework.downloader.support.DownloadProgressPrinter;
import cn.acyou.leo.framework.downloader.utils.RestTemplateBuilder;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.UUID;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractDownloader
implements Downloader {
    protected RestTemplate restTemplate = RestTemplateBuilder.builder().build();
    protected DownloadProgressPrinter downloadProgressPrinter;

    public AbstractDownloader(DownloadProgressPrinter downloadProgressPrinter) {
        this.downloadProgressPrinter = downloadProgressPrinter;
    }

    @Override
    public void download(String fileURL, String dir) throws IOException {
        long start = System.currentTimeMillis();
        String decodeFileURL = URLDecoder.decode(fileURL, "UTF-8");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity entity = this.restTemplate.exchange(decodeFileURL, HttpMethod.HEAD, requestEntity, String.class, new Object[0]);
        String fileName = this.getFileName(decodeFileURL, entity.getHeaders());
        this.doDownload(decodeFileURL, dir, fileName, entity.getHeaders());
        System.out.println("\u603b\u5171\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "s");
    }

    protected abstract void doDownload(String var1, String var2, String var3, HttpHeaders var4) throws IOException;

    private String getFileName(String fileURL, HttpHeaders headers) {
        String fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
        if (fileName.contains(".")) {
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (suffix.length() > 4 || suffix.contains("?")) {
                fileName = this.getFileNameFromHeader(headers);
            }
        } else {
            fileName = this.getFileNameFromHeader(headers);
        }
        return fileName;
    }

    private String getFileNameFromHeader(HttpHeaders headers) {
        String fileName = headers.getContentDisposition().getFilename();
        if (!StringUtils.hasText((String)fileName)) {
            return UUID.randomUUID().toString();
        }
        return fileName;
    }
}

